package ar.com.sdd.ebfapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.PaymentDocumentEbfApi;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/payment")
public class PaymentEbfApiEndpoint {

    @Inject
    private PaymentEbfApiService paymentEbfApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, PaymentDocumentEbfApi paymentDocumentEbfApi, @Context SecurityContext securityContext) {
        return paymentEbfApiService.postPayment(authorization, applicationId, ownerId, payerName, paymentDocumentEbfApi, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment")
    @Produces("application/json; charset=utf-8")
    public Response getPayerPayments(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName,
                               @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate, @Context SecurityContext securityContext) {
        return paymentEbfApiService.getPayerPayments(authorization, applicationId, ownerId, payerName, fromCreationDate, toCreationDate, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment/{paymentUid}")
    @Produces("application/json; charset=utf-8")
    public Response getPayerPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, @PathParam("paymentUid") String paymentUid, @Context SecurityContext securityContext) {
        return paymentEbfApiService.getPayerPayment(authorization, applicationId, ownerId, payerName, paymentUid, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment/{paymentUid}")
    @Produces("application/json; charset=utf-8")
    public Response deletePayerPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, @PathParam("paymentUid") String paymentUid, @Context SecurityContext securityContext) {
        return paymentEbfApiService.deletePayerPayment(authorization, applicationId, ownerId, payerName, paymentUid, securityContext);
    }

}
