package ar.com.sdd.ebfapi.api.account;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.CompanyAccountEbfApi;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/account")
public class AccountEbfApiEndpoint {

    @Inject
    private AccountEbfApiService accountEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/bank-accounts-search")
    @Produces("application/json; charset=utf-8")
    public Response getBankAccountsSearch(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                 @QueryParam("alias") String alias, @QueryParam("cbu") String cbu, @Context SecurityContext securityContext) {
        return accountEbfApiService.getBankAccountsSearch(authorization, applicationId, ownerId, alias, cbu, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/fiserv-cards")
    @Produces("application/json; charset=UTF-8")
    public Response getFiservCards(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @QueryParam("cuit") String fiservCardAccountOwnerCuit, @Context SecurityContext securityContext) {
        return accountEbfApiService.getFiservCards(authorization, aid, ownerId, fiservCardAccountOwnerCuit, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/fiserv-cards")
    @Produces("application/json; charset=UTF-8")
    public Response postFiservCard(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, CompanyAccountEbfApi fiservCardAccount, @Context SecurityContext securityContext) {
        return accountEbfApiService.postFiservCard(authorization, aid, ownerId, fiservCardAccount, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/fiserv-cards/{fiservCardAccountId}")
    @Produces("application/json; charset=UTF-8")
    public Response deleteFiservCard(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("fiservCardAccountId") String fiservCardAccountId, String sourceOperatorId, @Context SecurityContext securityContext) {
        return accountEbfApiService.deleteFiservCard(authorization, aid, ownerId, fiservCardAccountId, sourceOperatorId, securityContext);
    }

    @PUT
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/fiserv-cards/{fiservCardAccountId}")
    @Produces("application/json; charset=UTF-8")
    public Response putFiservCard(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("fiservCardAccountId") String fiservCardAccountId, CompanyAccountEbfApi fiservCardAccount, @Context SecurityContext securityContext) {
        return accountEbfApiService.putFiservCard(authorization, aid, ownerId, fiservCardAccountId, fiservCardAccount, securityContext);
    }
}