package ar.com.sdd.ebfapi.api.echeq;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/echeq")
public class EcheqEbfApiEndpoint {

    @Inject
    private EcheqEbfApiService echeqEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/find")
    @Produces("application/json; charset=utf-8")
    public Response getEcheqs(@HeaderParam("Authorization") String authorization,
                              @HeaderParam("Status") String status,
                              @HeaderParam("Account_Id") String accountId,
                              @PathParam("aid") String aid,
                              @PathParam("ownerId") String ownerId,
                              @Context SecurityContext securityContext) {
        return echeqEbfApiService.getEcheqs(authorization, status, accountId, aid, ownerId, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/echeq/{echeqId}/action/{action}/manage")
    @Produces("application/json; charset=utf-8")
    public Response manageEcheq(@HeaderParam("Authorization") String authorization,
                                @PathParam("aid") String aid,
                                @PathParam("ownerId") String ownerId,
                                @PathParam("echeqId") String echeqId,
                                @PathParam("action") String action,
                                @Context SecurityContext securityContext) {
        return echeqEbfApiService.manageEcheq(authorization, aid, ownerId, echeqId, action, securityContext);
    }

}
