package ar.com.sdd.ebfapi.api.erp;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.erp.ErpCompanySet;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/erp-company")
public class ErpCompanyEbfApiEndpoint {

    @Inject
    private ErpCompanyEbfApiService erpCompanyEbfApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/erp-company-set")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postErpCompanySet(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, ErpCompanySet erpCompanySet, @Context SecurityContext securityContext) {
        return erpCompanyEbfApiService.postErpCompanySet(authorization, applicationId, ownerId, erpCompanySet, securityContext);
    }
}