package ar.com.sdd.ebfapi.api.screen;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/screen")
public class ScreenEbfApiEndpoint {

    @SuppressWarnings("CdiInjectionPointsInspection")
    @Inject
    private ScreenEbfApiService screenEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/documents/{screenTemplateName}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreen(@HeaderParam("Authorization") String authorization,
                                         @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("screenTemplateName") String screenTemplateName,
                                         @QueryParam("legalDocRef") String legalDocRef, @QueryParam("legalDocRefLike") String legalDocRefLike,
                                         @QueryParam("ownerDocRef") String ownerDocRef, @QueryParam("ownerDocRefLike") String ownerDocRefLike,
                                         @QueryParam("fromIssueDate") String fromIssueDate, @QueryParam("toIssueDate") String toIssueDate,
                                         @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate,
                                         @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate,
                                         @QueryParam("divisionName") String divisionName,
                                         @QueryParam("issuerAccountReferenceLike") String issuerAccountReferenceLike,
                                         @QueryParam("billingAddressLike") String billingAddressLike,
                                         @QueryParam("payerRazonCodigo") String payerRazonCodigo, @QueryParam("payerCuitLike") String payerCuitLike,
                                         @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreen(authorization, applicationId, ownerId, null, screenTemplateName,
                legalDocRef, legalDocRefLike,
                ownerDocRef, ownerDocRefLike,
                fromIssueDate, toIssueDate,
                fromDueDate, toDueDate,
                fromCreationDate, toCreationDate,
                divisionName,
                issuerAccountReferenceLike,
                billingAddressLike,
                payerRazonCodigo, payerCuitLike,
                securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/documents/{screenTemplateName}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreen(@HeaderParam("Authorization") String authorization,
                                         @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerCuit") String payerCuit, @PathParam("screenTemplateName") String screenTemplateName,
                                         @QueryParam("legalDocRef") String legalDocRef, @QueryParam("legalDocRefLike") String legalDocRefLike,
                                         @QueryParam("ownerDocRef") String ownerDocRef, @QueryParam("ownerDocRefLike") String ownerDocRefLike,
                                         @QueryParam("fromIssueDate") String fromIssueDate, @QueryParam("toIssueDate") String toIssueDate,
                                         @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate,
                                         @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate,
                                         @QueryParam("divisionName") String divisionName,
                                         @QueryParam("issuerAccountReferenceLike") String issuerAccountReferenceLike,
                                         @QueryParam("billingAddressLike") String billingAddressLike,
                                         @QueryParam("payerRazonCodigo") String payerRazonCodigo, @QueryParam("payerCuitLike") String payerCuitLike,
                                         @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreen(authorization, applicationId, ownerId, payerCuit, screenTemplateName,
                legalDocRef, legalDocRefLike,
                ownerDocRef, ownerDocRefLike,
                fromIssueDate, toIssueDate,
                fromDueDate, toDueDate,
                fromCreationDate, toCreationDate,
                divisionName,
                issuerAccountReferenceLike,
                billingAddressLike,
                payerRazonCodigo, payerCuitLike,
                securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/documents/{screenTemplateName}/{screenTemplateBlock}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreen(@HeaderParam("Authorization") String authorization,
                                         @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, @PathParam("screenTemplateName") String screenTemplateName, @PathParam("screenTemplateBlock") Integer screenTemplateBlock,
                                         @QueryParam("legalDocRef") String legalDocRef, @QueryParam("legalDocRefLike") String legalDocRefLike,
                                         @QueryParam("ownerDocRef") String ownerDocRef, @QueryParam("ownerDocRefLike") String ownerDocRefLike,
                                         @QueryParam("fromIssueDate") String fromIssueDate, @QueryParam("toIssueDate") String toIssueDate,
                                         @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate,
                                         @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate,
                                         @QueryParam("divisionName") String divisionName,
                                         @QueryParam("issuerAccountReferenceLike") String issuerAccountReferenceLike,
                                         @QueryParam("billingAddressLike") String billingAddressLike,
                                         @QueryParam("payerRazonCodigo") String payerRazonCodigo, @QueryParam("payerCuitLike") String payerCuitLike,
                                         @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreen(authorization, applicationId, ownerId, payerName, screenTemplateName, screenTemplateBlock, null,
                legalDocRef, legalDocRefLike,
                ownerDocRef, ownerDocRefLike,
                fromIssueDate, toIssueDate,
                fromDueDate, toDueDate,
                fromCreationDate, toCreationDate,
                divisionName,
                issuerAccountReferenceLike,
                billingAddressLike,
                payerRazonCodigo, payerCuitLike,
                securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/documents/{screenTemplateName}/{screenTemplateBlock}/{screenTemplateMode}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreen(@HeaderParam("Authorization") String authorization,
                                         @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, @PathParam("screenTemplateName") String screenTemplateName, @PathParam("screenTemplateBlock") Integer screenTemplateBlock, @PathParam("screenTemplateMode") String screenTemplateMode,
                                         @QueryParam("legalDocRef") String legalDocRef, @QueryParam("legalDocRefLike") String legalDocRefLike,
                                         @QueryParam("ownerDocRef") String ownerDocRef, @QueryParam("ownerDocRefLike") String ownerDocRefLike,
                                         @QueryParam("fromIssueDate") String fromIssueDate, @QueryParam("toIssueDate") String toIssueDate,
                                         @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate,
                                         @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate,
                                         @QueryParam("divisionName") String divisionName,
                                         @QueryParam("issuerAccountReferenceLike") String issuerAccountReferenceLike,
                                         @QueryParam("billingAddressLike") String billingAddressLike,
                                         @QueryParam("payerRazonCodigo") String payerRazonCodigo, @QueryParam("payerCuitLike") String payerCuitLike,
                                         @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreen(authorization, applicationId, ownerId, payerName, screenTemplateName, screenTemplateBlock, screenTemplateMode,
                legalDocRef, legalDocRefLike,
                ownerDocRef, ownerDocRefLike,
                fromIssueDate, toIssueDate,
                fromDueDate, toDueDate,
                fromCreationDate, toCreationDate,
                divisionName,
                issuerAccountReferenceLike,
                billingAddressLike,
                payerRazonCodigo, payerCuitLike,
                securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/documents/{screenTemplateName}/{screenTemplateBlock}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreen(@HeaderParam("Authorization") String authorization,
                                         @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("screenTemplateName") String screenTemplateName, @PathParam("screenTemplateBlock") Integer screenTemplateBlock,
                                         @QueryParam("legalDocRef") String legalDocRef, @QueryParam("legalDocRefLike") String legalDocRefLike,
                                         @QueryParam("ownerDocRef") String ownerDocRef, @QueryParam("ownerDocRefLike") String ownerDocRefLike,
                                         @QueryParam("fromIssueDate") String fromIssueDate, @QueryParam("toIssueDate") String toIssueDate,
                                         @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate,
                                         @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate,
                                         @QueryParam("divisionName") String divisionName,
                                         @QueryParam("issuerAccountReferenceLike") String issuerAccountReferenceLike,
                                         @QueryParam("billingAddressLike") String billingAddressLike,
                                         @QueryParam("payerRazonCodigo") String payerRazonCodigo, @QueryParam("payerCuitLike") String payerCuitLike,
                                         @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreen(authorization, applicationId, ownerId, null, screenTemplateName, screenTemplateBlock, null,
                legalDocRef, legalDocRefLike,
                ownerDocRef, ownerDocRefLike,
                fromIssueDate, toIssueDate,
                fromDueDate, toDueDate,
                fromCreationDate, toCreationDate,
                divisionName,
                issuerAccountReferenceLike,
                billingAddressLike,
                payerRazonCodigo, payerCuitLike,
                securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/documents/{screenTemplateName}/{screenTemplateBlock}/{screenTemplateMode}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreen(@HeaderParam("Authorization") String authorization,
                                         @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("screenTemplateName") String screenTemplateName, @PathParam("screenTemplateBlock") Integer screenTemplateBlock, @PathParam("screenTemplateMode") String screenTemplateMode,
                                         @QueryParam("legalDocRef") String legalDocRef, @QueryParam("legalDocRefLike") String legalDocRefLike,
                                         @QueryParam("ownerDocRef") String ownerDocRef, @QueryParam("ownerDocRefLike") String ownerDocRefLike,
                                         @QueryParam("fromIssueDate") String fromIssueDate, @QueryParam("toIssueDate") String toIssueDate,
                                         @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate,
                                         @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate,
                                         @QueryParam("divisionName") String divisionName,
                                         @QueryParam("issuerAccountReferenceLike") String issuerAccountReferenceLike,
                                         @QueryParam("billingAddressLike") String billingAddressLike,
                                         @QueryParam("payerRazonCodigo") String payerRazonCodigo, @QueryParam("payerCuitLike") String payerCuitLike,
                                         @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreen(authorization, applicationId, ownerId, null, screenTemplateName, screenTemplateBlock, screenTemplateMode,
                legalDocRef, legalDocRefLike,
                ownerDocRef, ownerDocRefLike,
                fromIssueDate, toIssueDate,
                fromDueDate, toDueDate,
                fromCreationDate, toCreationDate,
                divisionName,
                issuerAccountReferenceLike,
                billingAddressLike,
                payerRazonCodigo, payerCuitLike,
                securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/documents-count/{screenTemplateName}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreenCount(@HeaderParam("Authorization") String authorization,
                                              @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerCuit") String payerCuit, @PathParam("screenTemplateName") String screenTemplateName,
                                              @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreenCount(authorization, applicationId, ownerId, payerCuit, screenTemplateName, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payerCuit/{payerCuit}/documents-sum/{screenTemplateName}/{sumVariable}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreenSum(@HeaderParam("Authorization") String authorization,
                                            @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerCuit") String payerCuit, @PathParam("screenTemplateName") String screenTemplateName, @PathParam("sumVariable") String sumVariable,
                                            @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreenSum(authorization, applicationId, ownerId, payerCuit, screenTemplateName, sumVariable, securityContext);
    }


    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/console")
    @Produces("application/json; charset=utf-8")
    public Response getConsoleScreen(@HeaderParam("Authorization") String authorization,
                                     @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName,
                                     @Context SecurityContext securityContext) {
        return screenEbfApiService.getConsoleScreen(authorization, applicationId, ownerId, payerName, securityContext);
    }
}