package ar.com.sdd.ebfapi.api.system;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import org.jboss.resteasy.annotations.Body;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/system")
public class SystemEbfApiServiceEndpoint {

    @Inject
    private SystemEbfApiService systemEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/check")
    public Response getCheck(@Context SecurityContext securityContext) {
        return systemEbfApiService.getCheck(securityContext);
    }


    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}notifyMail")
    @Consumes({"application/json"})
    public Response postNotifyMail(@HeaderParam("Authorization") String authorization,
                                   @PathParam("aid") String applicationId,
                                   @PathParam("ownerId") String ownerId,
                                   @QueryParam("address") String address,
                                   @QueryParam("subject") String subject,
                                   @QueryParam("body") String body,
                               @Context SecurityContext securityContext) {
        return systemEbfApiService.postNotifyEmail(authorization, applicationId,  ownerId, address, subject, body,securityContext);
    }

}
