package ar.com.sdd.ebfapi.api.system;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.model.NotifyRequest;
import org.jboss.resteasy.annotations.Body;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/system")
public class SystemEbfApiServiceEndpoint {

    @Inject
    private SystemEbfApiService systemEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/check")
    public Response getCheck(@Context SecurityContext securityContext) {
        return systemEbfApiService.getCheck(securityContext);
    }


    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/notify")
    @Consumes({"application/json"})
    public Response postNotify(@HeaderParam("Authorization") String authorization,
                                   @PathParam("aid") String applicationId,
                                   @PathParam("ownerId") String ownerId,
                               NotifyRequest request,
                               @Context SecurityContext securityContext) {
        return systemEbfApiService.postNotify(authorization, applicationId,  ownerId, request,securityContext);
    }

}
