package ar.com.sdd.ebfapi.api.erp;

import ar.com.sdd.ebfapi.client.model.erp.ErpDocumentSet;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public interface ErpPaymentEbfApiService {
    /* publica un conjunto de documentos para generar un actionlink con un link de pago
    *  return ActionLink
    */
    Response postErpDocumentSetPaymentLink(String authorization, String applicationId, String ownerId, ErpDocumentSet erpDocumentSet, SecurityContext securityContext);

    /* consulta estado de payments
    *  return Collection<ErpPayments>
    */
    Response getFindErpPayments(String authorization, String applicationId, String ownerId, String fromCreationDate, String toCreationDate, String ownerDocRefList, String legalDocRefList, Integer offset, Integer limit, SecurityContext securityContext);

    /* Busca pagos de un por rango de fechas o referencias
    *  return Collection<ErpPayments>
    */
    Response getPayments(String authorization, String applicationId, String ownerId, String fromCreationDate, String toCreationDate, String ownerDocRefList, String legalDocRefList, SecurityContext securityContext);

    /* Consulta status mas conciso de un orderNumber: status, fecha, xx
    *  return ErpPaymentStatusInfo
    */
    Response getPaymentStatusInfo(String authorization, String applicationId, String ownerId, String orderNumber, SecurityContext securityContext);

}
