package ar.com.sdd.ebfapi.api.payment;

import ar.com.sdd.ebfapi.client.model.PaymentDocumentEbfApi;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public interface PaymentEbfApiService {

    /* construye un pago completo con detalle de medios de pago ya*/
    Response postPayment(String authorization, String applicationId, String ownerId, String payerName, PaymentDocumentEbfApi paymentDocumentEbfApi, SecurityContext securityContext);

    /* Busca pagos de un payer especifico: por rango de fechas */
    Response getPayerPayments(String authorization, String applicationId, String ownerId, String payerName, String fromCreationDate, String toCreationDate, SecurityContext securityContext);

    /* Busca pagos de un payer especifico: por id de pago obfuscado  */
    Response getPayerPayment(String authorization, String applicationId, String ownerId, String payerName, String paymentUid, SecurityContext securityContext);

    /* Elimina un pagos de un payer especifico: por id de pago obfuscado  */
    Response deletePayerPayment(String authorization, String applicationId, String ownerId, String payerName, String paymentUid, SecurityContext securityContext);


}

