package ar.com.sdd.ebfapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/payment")
public class PaymentEbfApiEndpoint {

    @Inject
    private PaymentEbfApiService paymentEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/expiration")
    @Produces("application/json; charset=utf-8")
    public Response getNextBillExpirationList(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, @Context SecurityContext securityContext) {
        return paymentEbfApiService.getNextBillExpirationList(authorization, applicationId, ownerId, payerName, securityContext);
    }

}
