package ar.com.sdd.ebfapi.privateapi;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/private/sequencer")
public class SequencerPrivateEbfApiEndpoint {

    @Inject
    private SequencerPrivateEbfApiService service;

    @GET
    @ServerFileLogged
    @Path("/sequence/{name}")
    @Produces("application/json; charset=utf-8")
    public Response getSequence(@HeaderParam("Authorization") String privateAuthorizationBearer, @PathParam("name") String name, @Context SecurityContext securityContext) {
        return service.getSequence(privateAuthorizationBearer, name, securityContext);
    }

}
