package ar.com.sdd.ebfapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.PaymentDocumentEbfApi;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import java.util.Date;

@Path("/ebfapi/v1_0/payment")
public class PaymentEbfApiEndpoint {

    @Inject
    private PaymentEbfApiService paymentEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/expiration")
    @Produces("application/json; charset=utf-8")
    public Response getNextBillExpirationList(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, @Context SecurityContext securityContext) {
        return paymentEbfApiService.getNextBillExpirationList(authorization, applicationId, ownerId, payerName, securityContext);
    }


    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, PaymentDocumentEbfApi paymentDocumentEbfApi, @Context SecurityContext securityContext) {
        return paymentEbfApiService.postPayment(authorization, applicationId, ownerId, payerName, paymentDocumentEbfApi, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment")
    @Produces("application/json; charset=utf-8")
    public Response getPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName,
                               @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate, @Context SecurityContext securityContext) {
        return paymentEbfApiService.getPayments(authorization, applicationId, ownerId, payerName, fromCreationDate, toCreationDate, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment/{paymentId}")
    @Produces("application/json; charset=utf-8")
    public Response getPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, @PathParam("paymentId") String paymentId, @Context SecurityContext securityContext) {
        return paymentEbfApiService.getPayment(authorization, applicationId, ownerId, payerName, paymentId, securityContext);
    }

}
