package ar.com.sdd.ebfapi.api.auth;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;
import ar.com.sdd.commons.rest.model.OAuth2SsoCredential;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/auth")
public class AuthEbfApiEndpoint {

    @Inject private AuthEbfApiService authEbfApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/token.oauth2")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postTokenOauth2(@PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        //POR DEFAULT, USAMOS LOGIN BY NAME
        return authEbfApiService.postTokenOauth2(applicationId, AuthEbfApiService.OWNER_LOGIN_TYPE.BY_NAME, ownerId, oauthCredentials, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/ssocheck/{tokenId}")
    @Produces("application/json; charset=utf-8")
    public Response getSsoCheck(@PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("tokenId") String tokenId, @Context SecurityContext securityContext) {
        return authEbfApiService.getSsoCheck(applicationId, ownerId, tokenId, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/session")
    @Produces("application/json; charset=utf-8")
    public Response getSession(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @Context SecurityContext securityContext) {
        return authEbfApiService.getSession(authorization, applicationId, ownerId, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/ssolink")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postSsoLink(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, OAuth2SsoCredential oauthCredentials, @Context SecurityContext securityContext) {
        return authEbfApiService.postSsoLink(authorization, applicationId, ownerId, oauthCredentials, securityContext);
    }


}
