package ar.com.sdd.ebfapi.api.screen;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/screen")
public class ScreenEbfApiEndpoint {

    @Inject
    private ScreenEbfApiService screenEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/documents/{screenTemplateName}/{screenTemplateBlock}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreen(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName,
                                         @PathParam("screenTemplateName") String screenTemplateName, @PathParam("screenTemplateBlock") Integer screenTemplateBlock,
                                         @QueryParam("legalDocRefLike") String legalDocRefLike, @QueryParam("divisionName") String divisionName, @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate, @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreen(authorization, applicationId, ownerId, payerName, screenTemplateName, screenTemplateBlock, null, legalDocRefLike, divisionName, fromDueDate, toDueDate, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/documents/{screenTemplateName}/{screenTemplateBlock}/{screenTemplateMode}")
    @Produces("application/json; charset=utf-8")
    public Response getDocumentsOnScreen(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName,
                                         @PathParam("screenTemplateName") String screenTemplateName, @PathParam("screenTemplateBlock") Integer screenTemplateBlock, @PathParam("screenTemplateMode") String screenTemplateMode,
                                         @QueryParam("legalDocRefLike") String legalDocRefLike, @QueryParam("divisionName") String divisionName, @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate, @Context SecurityContext securityContext) {
        return screenEbfApiService.getDocumentsOnScreen(authorization, applicationId, ownerId, payerName, screenTemplateName, screenTemplateBlock, screenTemplateMode, legalDocRefLike, divisionName, fromDueDate, toDueDate, securityContext);
    }


    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payer/{payerName}/console")
    @Produces("application/json; charset=utf-8")
    public Response getConsoleScreen(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, @PathParam("payerName") String payerName, @Context SecurityContext securityContext) {
        return screenEbfApiService.getConsoleScreen(authorization, applicationId, ownerId, payerName, securityContext);
    }

}
