package ar.com.sdd.ebfapi.api.erp;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/erp-payment")
public class ErpPaymentEbfApiEndpoint {

    @Inject private ErpPaymentEbfApiService erpPaymentEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/find-erp-payments")
    @Produces("application/json; charset=utf-8")
    public Response getFindErpPayments(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                       @QueryParam("fromCreationDate") String fromCreationDate,
                                       @QueryParam("toCreationDate") String toCreationDate,
                                       @QueryParam("ownerDocRefList") String ownerDocRefList,
                                       @QueryParam("offset") Integer offset,
                                       @QueryParam("limit") Integer limit,
                                       @Context SecurityContext securityContext) {
        return erpPaymentEbfApiService.getFindErpPayments(authorization, applicationId, ownerId, fromCreationDate, toCreationDate, ownerDocRefList, offset, limit, securityContext);
    }


}
