package ar.com.sdd.ebfapi.api.fce;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.PaymentDocumentEbfApi;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/fce-payment")
public class FcePaymentEbfApiEndpoint {

    @Inject
    private FcePaymentEbfApiService fcePaymentEbfApiService;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/notify-payment")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postNotifyPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, PaymentDocumentEbfApi paymentDocumentEbfApi, @Context SecurityContext securityContext) {
        return fcePaymentEbfApiService.postNotifyPayment(authorization, aid, ownerId, paymentDocumentEbfApi, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/execute-payment")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postExecutePayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, PaymentDocumentEbfApi paymentDocumentEbfApi, @Context SecurityContext securityContext) {
        return fcePaymentEbfApiService.postExecutePayment(authorization, aid, ownerId, paymentDocumentEbfApi, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payments")
    @Produces("application/json; charset=utf-8")
    public Response getPayments(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId,
                                @QueryParam("fromCreationDate") String fromCreationDate, @QueryParam("toCreationDate") String toCreationDate,
                                @QueryParam("offset") Integer offset, @QueryParam("limit") Integer limit, @Context SecurityContext securityContext) {
        return fcePaymentEbfApiService.getPayments(authorization, aid, ownerId, fromCreationDate, offset, limit, toCreationDate, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/payments/{paymentId}")
    @Produces("application/json; charset=utf-8")
    public Response getPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId, @PathParam("paymentId") String paymentId, @Context SecurityContext securityContext) {
        return fcePaymentEbfApiService.getPayment(authorization, aid, ownerId, paymentId, securityContext);
    }

}
