package ar.com.sdd.ebfapi.api;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.commons.rest.model.OAuth2Credential;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/auth")
public class AuthEbfApi {

    @Inject
    private AuthEbfApiService service;

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerName}/token.oauth2")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postTokenOauth2(@PathParam("aid") String applicationId, @PathParam("ownerName") String ownerName, OAuth2Credential oauthCredentials, @Context SecurityContext securityContext) {
        return service.postTokenOauth2(applicationId, ownerName, oauthCredentials, securityContext);
    }

}
