/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.ebfapi.api.payment;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.api.payment.PaymentEbfApiService;
import ar.com.sdd.ebfapi.client.model.PaymentDocumentEbfApi;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/ebfapi/v1_0/payment")
public class PaymentEbfApiEndpoint {
    @Inject
    private PaymentEbfApiService paymentEbfApiService;

    @POST
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json; charset=utf-8"})
    public Response postPayment(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="payerName") String payerName, PaymentDocumentEbfApi paymentDocumentEbfApi, @Context SecurityContext securityContext) {
        return this.paymentEbfApiService.postPayment(authorization, applicationId, ownerId, payerName, paymentDocumentEbfApi, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getPayment(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="payerName") String payerName, @QueryParam(value="fromCreationDate") String fromCreationDate, @QueryParam(value="toCreationDate") String toCreationDate, @Context SecurityContext securityContext) {
        return this.paymentEbfApiService.getPayments(authorization, applicationId, ownerId, payerName, fromCreationDate, toCreationDate, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment/{paymentUid}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response getPayment(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="payerName") String payerName, @PathParam(value="paymentUid") String paymentUid, @Context SecurityContext securityContext) {
        return this.paymentEbfApiService.getPayment(authorization, applicationId, ownerId, payerName, paymentUid, securityContext);
    }

    @DELETE
    @ServerFileLogged
    @Path(value="/aid/{aid}/owner/{ownerId}/payer/{payerName}/payment/{paymentUid}")
    @Produces(value={"application/json; charset=utf-8"})
    public Response deletePayment(@HeaderParam(value="Authorization") String authorization, @PathParam(value="aid") String applicationId, @PathParam(value="ownerId") String ownerId, @PathParam(value="payerName") String payerName, @PathParam(value="paymentUid") String paymentUid, @Context SecurityContext securityContext) {
        return this.paymentEbfApiService.deletePayment(authorization, applicationId, ownerId, payerName, paymentUid, securityContext);
    }
}

