package ar.com.sdd.ebfapi.api.fce;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/fce-document")
public class FceDocumentEbfApiEndpoint {

    @Inject
    private FceDocumentEbfApiService fceDocumentEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/find-documents")
    @Produces("application/json; charset=utf-8")
    public Response getFindDocuments(@HeaderParam("Authorization") String authorization, @PathParam("aid") String aid, @PathParam("ownerId") String ownerId,
                                     @QueryParam("fromIssueDate") String fromIssueDate, @QueryParam("toIssueDate") String toIssueDate,
                                     @QueryParam("fromDueDate") String fromDueDate, @QueryParam("toDueDate") String toDueDate,
                                     @QueryParam("offset") Integer offset, @QueryParam("limit") Integer limit, @Context SecurityContext securityContext) {
        return fceDocumentEbfApiService.getFindDocuments(authorization, aid, ownerId, fromIssueDate, toIssueDate, fromDueDate, toDueDate, offset, limit, securityContext);
    }

}
