package ar.com.sdd.ebfapi.api.company;

import ar.com.sdd.commons.rest.log.ServerFileLogged;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_0/company")
public class CompanyEbfApiEndpoint {

    @Inject
    private CompanyEbfApiService companyEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/lstpayers")
    @Produces("application/json; charset=utf-8")
    public Response getLstPayers(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                 @QueryParam("name") String name, @QueryParam("razonSocial") String razonSocial,
                                 @QueryParam("codigo") String payerCode, @QueryParam("cuit") String cuit,
                                 @Context SecurityContext securityContext) {
        return companyEbfApiService.getLstPayers(authorization, applicationId, ownerId, name, razonSocial, payerCode, cuit, securityContext);
    }
}