package ar.com.sdd.ebfapi.api.erp;

import ar.com.sdd.commons.rest.log.ServerFileLogged;
import ar.com.sdd.ebfapi.client.model.erp.ErpDocumentSet;

import javax.inject.Inject;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path("/ebfapi/v1_1/erp-payment")
public class ErpPaymentEbfApiEndpoint {

    @Inject private ErpPaymentEbfApiService erpPaymentEbfApiService;

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/find-erp-payments")
    @Produces("application/json; charset=utf-8")
    public Response getFindErpPayments(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                                       @QueryParam("fromCreationDate") String fromCreationDate,
                                       @QueryParam("toCreationDate") String toCreationDate,
                                       @QueryParam("ownerDocRefList") String ownerDocRefList,
                                       @QueryParam("legalDocRefList") String legalDocRefList,
                                       @QueryParam("offset") Integer offset,
                                       @QueryParam("limit") Integer limit,
                                       @Context SecurityContext securityContext) {
        return erpPaymentEbfApiService.getFindErpPayments(authorization, applicationId, ownerId, fromCreationDate, toCreationDate, ownerDocRefList, legalDocRefList,offset, limit, securityContext);
    }

    @POST
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/erp-document-set/payment-link")
    @Consumes({"application/json"})
    @Produces("application/json; charset=utf-8")
    public Response postErpDocumentSetPaymentLink(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId, ErpDocumentSet erpDocumentSet, @Context SecurityContext securityContext) {
        return erpPaymentEbfApiService.postErpDocumentSetPaymentLink(authorization, applicationId, ownerId, erpDocumentSet, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/erp-payments")
    @Produces("application/json; charset=utf-8")
    public Response getPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,
                               @QueryParam("fromCreationDate") String fromCreationDate,
                               @QueryParam("toCreationDate") String toCreationDate,
                               @QueryParam("ownerDocRefList") String ownerDocRefList,
                               @QueryParam("legalDocRefList") String legalDocRefList,
                               @Context SecurityContext securityContext) {
        return erpPaymentEbfApiService.getPayments(authorization, applicationId, ownerId, fromCreationDate, toCreationDate, ownerDocRefList, legalDocRefList, securityContext);
    }

    @GET
    @ServerFileLogged
    @Path("/aid/{aid}/owner/{ownerId}/erp-payment-status-info/orderNumber/{orderNumber}")
    @Produces("application/json; charset=utf-8")
    public Response getPayment(@HeaderParam("Authorization") String authorization, @PathParam("aid") String applicationId, @PathParam("ownerId") String ownerId,@PathParam("orderNumber") String orderNumber,
                               @Context SecurityContext securityContext) {
        return erpPaymentEbfApiService.getPaymentStatusInfo(authorization, applicationId, ownerId, orderNumber, securityContext);
    }

}
