package ar.com.sdd.edireader;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.tokenizer.Tokenizer;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

import ar.com.sdd.edireader.model.EdifactData;

public class EbfEdiScanner {


    private EDIReader parser;
    private InputSource inputSource;
    private static EdifactData edfdata = new EdifactData();


    public EbfEdiScanner(String input, String output) {
        if(input != null) {
            try {
                inputSource =  new InputSource(new FileReader(input));
            }catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }

        }
    }
    public void run() {
        ContentHandler handler = new ScanningHadler();
        char[] preRead = null;

        try {
            while (true) {

                parser = EDIReaderFactory.createEDIReader(inputSource, preRead);

                if(parser == null) {
                    break;
                }
                parser.setContentHandler(handler);
                parser.parse(inputSource);
                preRead = parser.getTokenizer().getBuffered();
            }
        }catch (IOException e) {
            throw new RuntimeException(e.getMessage());

        }catch (SAXException syntaxException) {
            System.out.println("Unrecoverable syntax exception: " + syntaxException.getClass().getCanonicalName() +
                    " - " + syntaxException.getMessage());

            Tokenizer ediTokenizer = parser.getTokenizer();
            System.out.println("Información de la EDIReader");
            char delimiter = ediTokenizer.getDelimiter();
            System.out.println("Field delimiter: " + representationOf(delimiter));
            char terminator = ediTokenizer.getTerminator();
            System.out.println("Segment terminator: " + representationOf(terminator));

            throw new RuntimeException(syntaxException.getMessage());
        }


    }

    private String representationOf(char c)
    {
        String result = "|" + c + "|";
        result += " (" + (int) c + ")";
        return result;
    }

    private class ScanningHadler extends DefaultHandler {

        @Override
        public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {

            if(localName.startsWith(parser.getXMLTags().getAddressTag())) {

            }
        }
    }
}
