/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.edireader;

import ar.com.sdd.edireader.model.EdifactData;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.io.FileReader;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EbfEdiScanner {
    private EDIReader parser;
    private InputSource inputSource;
    private static EdifactData edfdata = new EdifactData();

    public EbfEdiScanner(String input, String output) {
        if (input != null) {
            try {
                this.inputSource = new InputSource(new FileReader(input));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void run() {
        ScanningHadler handler = new ScanningHadler();
        char[] preRead = null;
        try {
            while (true) {
                this.parser = EDIReaderFactory.createEDIReader(this.inputSource, preRead);
                if (this.parser != null) {
                    this.parser.setContentHandler(handler);
                    this.parser.parse(this.inputSource);
                    preRead = this.parser.getTokenizer().getBuffered();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (SAXException syntaxException) {
            System.out.println("Unrecoverable syntax exception: " + syntaxException.getClass().getCanonicalName() + " - " + syntaxException.getMessage());
            Tokenizer ediTokenizer = this.parser.getTokenizer();
            System.out.println("Informaci\u00f3n de la EDIReader");
            char delimiter = ediTokenizer.getDelimiter();
            System.out.println("Field delimiter: " + this.representationOf(delimiter));
            char terminator = ediTokenizer.getTerminator();
            System.out.println("Segment terminator: " + this.representationOf(terminator));
            throw new RuntimeException(syntaxException.getMessage());
        }
    }

    private String representationOf(char c) {
        String result = "|" + c + "|";
        result = result + " (" + c + ")";
        return result;
    }

    private class ScanningHadler
    extends DefaultHandler {
        private ScanningHadler() {
        }

        @Override
        public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
            if (localName.startsWith(EbfEdiScanner.this.parser.getXMLTags().getAddressTag())) {
                // empty if block
            }
        }
    }
}

