/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import ar.com.sdd.edireader.model.EdifactData;
import ar.com.sdd.edireader.model.EdifactItem;
import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.StandardReader;
import com.berryworks.edireader.error.GroupCountException;
import com.berryworks.edireader.error.InterchangeControlNumberException;
import com.berryworks.edireader.error.SegmentCountException;
import com.berryworks.edireader.error.TransactionControlNumberException;
import com.berryworks.edireader.tokenizer.Token;
import com.berryworks.edireader.util.ContentHandlerBase64Encoder;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class EdifactReader
extends StandardReader {
    private static final Logger log = Logger.getLogger(EdifactReader.class);
    protected static final int ELEMENTS_IN_SEGMENT_MAXIMUM = 50;
    protected static final int ELEMENTS_IN_UNB_MAXIMUM = 30;
    protected boolean ungExplicit;
    protected boolean witnessedUNA;
    private EdifactData edifactData = new EdifactData();
    private String subElemetValue = "";
    private Collection<EdifactItem> edifactItems = new ArrayList<EdifactItem>();
    private EdifactItem edifactItem = new EdifactItem();

    @Override
    protected Token recognizeBeginning() throws IOException, SAXException {
        Token t = this.getTokenizer().nextToken();
        if (t.getType() == Token.TokenType.SEGMENT_START) {
            String segType = t.getValue();
            if ("UNA".equals(segType)) {
                this.witnessedUNA = true;
                this.getTokenizer().skipSegment();
                t = this.getTokenizer().nextToken();
                if (t.getType() == Token.TokenType.SEGMENT_START) {
                    segType = t.getValue();
                } else {
                    throw new EDISyntaxException("Improperly formed UNA segment", this.getTokenizer());
                }
            }
            if (!"UNB".equals(segType)) {
                if (this.witnessedUNA) {
                    throw new EDISyntaxException("Mandatory UNB segment was not recognized after UNA. Terminator problem?");
                }
                throw new EDISyntaxException("First segment must be UNA or UNB", this.getTokenizer());
            }
        } else {
            throw new EDISyntaxException("First segment must be UNA or UNB");
        }
        return t;
    }

    @Override
    protected Token parseInterchange(Token token) throws SAXException, IOException {
        String s;
        String sType;
        if (debug) {
            EdifactReader.trace("entering parseInterchange for an EDIFACT interchange");
        }
        this.getInterchangeAttributes().clear();
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getStandard(), "EDIFACT");
        this.setGroupCount(0);
        List<String> compositeList = this.getTokenizer().nextCompositeElement();
        String syntaxIdentifier = this.getSubElement(compositeList, 0);
        String syntaxVersionNumber = this.getSubElement(compositeList, 1);
        if (syntaxIdentifier.length() > 0) {
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSyntaxIdentifier(), syntaxIdentifier);
            if (syntaxVersionNumber.length() > 0) {
                this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSyntaxVersion(), syntaxVersionNumber);
            }
        }
        compositeList = this.getTokenizer().nextCompositeElement();
        String fromId = this.getSubElement(compositeList, 0);
        String fromQual = this.getSubElement(compositeList, 1);
        String fromExtra = this.getSubElement(compositeList, 2);
        compositeList = this.getTokenizer().nextCompositeElement();
        String toId = this.getSubElement(compositeList, 0);
        String toQual = this.getSubElement(compositeList, 1);
        String toExtra = this.getSubElement(compositeList, 2);
        compositeList = this.getTokenizer().nextCompositeElement();
        String date = this.getSubElement(compositeList, 0);
        String time = this.getSubElement(compositeList, 1);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getDate(), date);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getTime(), time);
        this.setInterchangeControlNumber(this.getTokenizer().nextSimpleValue());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getControl(), this.getInterchangeControlNumber());
        this.remainderOfUNB();
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getDecimal(), String.valueOf(this.getDecimalMark()));
        this.startInterchange(this.getInterchangeAttributes());
        this.getInterchangeAttributes().clear();
        this.startElement(this.getXMLTags().getSenderTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getIdAttribute(), fromId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getQualifierAttribute(), fromQual);
        if (EdifactReader.isPresent(fromExtra)) {
            this.getInterchangeAttributes().addCDATA("Extra", fromExtra);
        }
        this.startSenderAddress(this.getInterchangeAttributes());
        this.endElement(this.getXMLTags().getAddressTag());
        this.endElement(this.getXMLTags().getSenderTag());
        this.getInterchangeAttributes().clear();
        this.startElement(this.getXMLTags().getReceiverTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getIdAttribute(), toId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getQualifierAttribute(), toQual);
        if (EdifactReader.isPresent(toExtra)) {
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getAddressExtraAttribute(), toExtra);
        }
        this.startReceiverAddress(this.getInterchangeAttributes());
        this.endElement(this.getXMLTags().getAddressTag());
        this.endElement(this.getXMLTags().getReceiverTag());
        while (true) {
            this.ungExplicit = true;
            token = this.getTokenizer().nextToken();
            if (token.getType() != Token.TokenType.SEGMENT_START) {
                throw new EDISyntaxException("Invalid beginning of UNG|UNH|UNZ segment", this.getTokenizer());
            }
            sType = token.getValue();
            if (sType.equals("UNG")) {
                this.setGroupCount(1 + this.getGroupCount());
                this.parseFunctionalGroup(token);
                continue;
            }
            if (!sType.equals("UNH")) break;
            this.impliedFunctionalGroup(token);
        }
        if (!sType.equals("UNZ")) {
            throw new EDISyntaxException("Unexpected segment type in this context", "UNH, UNZ, or UNG", sType, this.getTokenizer());
        }
        int n = this.getTokenizer().nextIntValue();
        if (this.getGroupCount() != n) {
            GroupCountException groupCountException = new GroupCountException("Functional group count error in UNZ segment", this.getGroupCount(), n, this.getTokenizer());
            this.setSyntaxException(groupCountException);
            if (!this.recover(groupCountException)) {
                throw groupCountException;
            }
        }
        if (!(s = this.getTokenizer().nextSimpleValue()).equals(this.getInterchangeControlNumber())) {
            InterchangeControlNumberException interchangeControlNumberException = new InterchangeControlNumberException("Control number error in UNZ segment", this.getInterchangeControlNumber(), s, this.getTokenizer());
            this.setSyntaxException(interchangeControlNumberException);
            if (!this.recover(interchangeControlNumberException)) {
                throw interchangeControlNumberException;
            }
        }
        this.endInterchange();
        Token lastToken = this.getTokenizer().skipSegment();
        return lastToken;
    }

    protected String getSubElement(List<String> compositeList, int i) {
        String result = "";
        try {
            result = compositeList.get(i);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    protected void remainderOfUNB() throws IOException, EDISyntaxException {
        if (this.hitEndOfSegment(this.getXMLTags().getRecipientReference()) || this.hitEndOfSegment(this.getXMLTags().getApplicationReference()) || this.hitEndOfSegment(this.getXMLTags().getProcessingPriority()) || this.hitEndOfSegment(this.getXMLTags().getAcknowledgementRequest()) || this.hitEndOfSegment(this.getXMLTags().getInterchangeAgreementIdentifier()) || this.hitEndOfSegment(this.getXMLTags().getTestIndicator())) {
            return;
        }
        while (this.getTokenizer().nextToken().getType() != Token.TokenType.SEGMENT_END) {
            if (this.getTokenizer().getElementInSegmentCount() <= 30) continue;
            throw new EDISyntaxException("Too many (" + this.getTokenizer().getElementInSegmentCount() + ") elements for a UNB. Segment terminator problem?", this.getTokenizer());
        }
    }

    protected boolean hitEndOfSegment(String attributeName) throws EDISyntaxException, IOException {
        Token token = this.getTokenizer().nextToken();
        if (token.getType() == Token.TokenType.SEGMENT_END) {
            return true;
        }
        if (token.getType() == Token.TokenType.SIMPLE) {
            this.getInterchangeAttributes().addCDATA(attributeName, token.getValue());
        }
        return false;
    }

    protected Token parseFunctionalGroup(Token token) throws SAXException, IOException {
        String sType;
        int docCount = 0;
        this.getGroupAttributes().clear();
        this.getGroupAttributes().addCDATA("GroupType", this.getTokenizer().nextSimpleValue());
        this.getTokenizer().nextCompositeElement();
        this.getTokenizer().nextCompositeElement();
        this.getTokenizer().nextCompositeElement();
        this.setGroupControlNumber(this.getTokenizer().nextSimpleValue());
        this.getGroupAttributes().addCDATA(this.getXMLTags().getControl(), this.getGroupControlNumber());
        this.getGroupAttributes().addCDATA("StandardCode", this.getTokenizer().nextSimpleValue());
        this.getTokenizer().nextCompositeElement();
        this.startElement(this.getXMLTags().getGroupTag(), this.getGroupAttributes());
        this.getTokenizer().skipSegment();
        while (true) {
            if ((token = this.getTokenizer().nextToken()).getType() != Token.TokenType.SEGMENT_START) {
                throw new EDISyntaxException("Invalid beginning of UNH|UNE segment", this.getTokenizer().getSegmentCount());
            }
            sType = token.getValue();
            if (!sType.equals("UNH")) break;
            ++docCount;
            this.parseDocument(token);
        }
        if (!sType.equals("UNE")) {
            throw new EDISyntaxException("Expected UNE or UNH segment instead of " + sType, this.getTokenizer());
        }
        int n = this.getTokenizer().nextIntValue();
        if (docCount != n) {
            throw new EDISyntaxException("Transaction set count error in UNE segment. Expected " + docCount + " instead of " + n, this.getTokenizer());
        }
        String s = this.getTokenizer().nextSimpleValue();
        if (!s.equals(this.getGroupControlNumber())) {
            throw new EDISyntaxException("Control number error in UNE segment. Expected " + this.getGroupControlNumber() + " instead of " + s, this.getTokenizer());
        }
        this.endElement(this.getXMLTags().getGroupTag());
        Token retval = this.getTokenizer().skipSegment();
        return retval;
    }

    protected Token impliedFunctionalGroup(Token token) throws SAXException, IOException {
        String sType;
        this.getGroupAttributes().clear();
        this.startElement(this.getXMLTags().getGroupTag(), this.getGroupAttributes());
        while (true) {
            if (token.getType() != Token.TokenType.SEGMENT_START) {
                throw new EDISyntaxException("Invalid beginning of UNH|UNZ segment", this.getTokenizer().getSegmentCount());
            }
            sType = token.getValue();
            if (!sType.equals("UNH")) break;
            this.setGroupCount(1 + this.getGroupCount());
            this.parseDocument(token);
            token = this.getTokenizer().nextToken();
        }
        if (!sType.equals("UNZ")) {
            throw new EDISyntaxException("Unexpected segment type in this context", "UNH or UNZ", sType, this.getTokenizer());
        }
        this.getTokenizer().ungetToken();
        this.endElement(this.getXMLTags().getGroupTag());
        return token;
    }

    protected Token parseDocument(Token token) throws SAXException, IOException {
        String s;
        String segmentType;
        String accessReference;
        String messageType = "";
        String messageVersion = "";
        String messageRelease = "";
        int segCount = 2;
        this.getDocumentAttributes().clear();
        String control = this.getTokenizer().nextSimpleValue();
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getControl(), control);
        List<String> v = this.getTokenizer().nextCompositeElement();
        if (v != null) {
            int n = v.size();
            String obj = v.get(0);
            if (obj != null) {
                messageType = obj;
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getDocumentType(), messageType);
            }
            if (n > 1 && (obj = v.get(1)) != null) {
                messageVersion = obj;
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getMessageVersion(), messageVersion);
            }
            if (n > 2 && (obj = v.get(2)) != null) {
                messageRelease = obj;
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getMessageRelease(), messageRelease);
            }
            if (n > 3 && (obj = v.get(3)) != null) {
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getAgency(), obj);
            }
            if (n > 4 && (obj = v.get(4)) != null) {
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getAssociation(), obj);
            }
        }
        if (EdifactReader.emptyStringIfNull(accessReference = this.getTokenizer().nextSimpleValue(false, true)).length() > 0) {
            this.getDocumentAttributes().addCDATA(this.getXMLTags().getAccessReference(), accessReference);
        }
        PluginController pluginController = PluginController.create("EDIFACT", messageType, messageVersion, messageRelease, this.getTokenizer());
        PluginController.setDebug(debug);
        if (pluginController.isEnabled()) {
            this.getDocumentAttributes().addCDATA(this.getXMLTags().getName(), pluginController.getDocumentName());
        }
        this.startMessage(this.getDocumentAttributes());
        while (!(segmentType = this.getTokenizer().nextSegment()).equals("UNT")) {
            ++segCount;
            if ("UNO".equals(segmentType)) {
                this.parseUNOUNPSequence();
                ++segCount;
                continue;
            }
            this.parseSegment(pluginController, segmentType);
        }
        int toClose = pluginController.getNestingLevel();
        if (debug) {
            EdifactReader.trace("closing all " + toClose + " loops");
        }
        while (toClose > 0) {
            this.endElement(this.getXMLTags().getLoopTag());
            --toClose;
        }
        int n = this.getTokenizer().nextIntValue();
        if (segCount != n) {
            SegmentCountException countException = new SegmentCountException("Segment count error in UNT segment", segCount, n, this.getTokenizer());
            this.setSyntaxException(countException);
            if (!this.recover(countException)) {
                throw countException;
            }
        }
        if (!(s = this.getTokenizer().nextSimpleValue()).equals(control)) {
            TransactionControlNumberException transactionControlNumberException = new TransactionControlNumberException("Control number error in UNT segment", control, s, this.getTokenizer());
            this.setSyntaxException(transactionControlNumberException);
            if (!this.recover(transactionControlNumberException)) {
                throw transactionControlNumberException;
            }
        }
        this.endElement(this.getXMLTags().getDocumentTag());
        Token retval = this.getTokenizer().skipSegment();
        return retval;
    }

    @Override
    public void parseSegmentElement(Token t) throws SAXException {
        super.parseSegmentElement(t);
        String DTM = "DTM";
        String MOA01 = "MOA01";
        String NAD = "NAD";
        String BGM02 = "BGM02";
        String LIN03 = "LIN03";
        String PIA2 = "PIA2";
        String IMD03 = "IMD03";
        String elementId = t.getElementId();
        String value = t.getValue().trim();
        int subElementIndex = t.getSubIndex();
        if (subElementIndex == 0) {
            this.subElemetValue = value;
        }
        try {
            switch (elementId) {
                case "BGM02": {
                    this.edifactData.setLegalDocRef(value);
                    break;
                }
                case "DTM": {
                    String localDateFormat = "yyyyMMdd";
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(localDateFormat);
                    if (!EdifactReader.isValidDate(value, localDateFormat)) break;
                    LocalDate localDate = LocalDate.parse(value, formatter);
                    if (subElementIndex == 1 & this.subElemetValue.equals("137")) {
                        this.edifactData.setDeliveryDate(localDate);
                        break;
                    }
                    if (subElementIndex == 1 & this.subElemetValue.equals("35")) {
                        this.edifactData.setDueDate(localDate);
                    }
                    break;
                }
                case "MOA01": {
                    NumberFormat numberFormat = NumberFormat.getInstance(new Locale("es", "AR"));
                    Number format = numberFormat.parse(value);
                    BigDecimal numberFormated = new BigDecimal(format.toString()).setScale(2, 4);
                    if (subElementIndex == 1 & this.subElemetValue.equals("124")) {
                        this.edifactData.setDueAmount(numberFormated.doubleValue());
                        break;
                    }
                    if (subElementIndex == 1 & this.subElemetValue.equals("125")) {
                        this.edifactData.setTotalAmount(numberFormated.doubleValue());
                        break;
                    }
                    if (!(subElementIndex == 1 & this.subElemetValue.equals("203"))) break;
                    this.edifactItem.setQuantity(numberFormated.doubleValue());
                    break;
                }
                case "LIN03": {
                    if (subElementIndex != 0) break;
                    this.edifactItem.setSkuCode(value);
                    break;
                }
                case "PIA2": {
                    if (subElementIndex != 0) break;
                    break;
                }
                case "IMD03": {
                    if (subElementIndex != 3) break;
                    this.edifactItem.setDescription(value);
                }
            }
        }
        catch (DateTimeParseException e) {
            log.error((Object)(value + " no es una fecha"));
        }
        catch (Exception e) {
            log.error((Object)"Error al procesar edfData");
        }
    }

    protected void parseUNOUNPSequence() throws SAXException, IOException {
        int length;
        if (debug) {
            EdifactReader.trace("UNO detected, introducing an octet sequence object");
        }
        String lengthField = "";
        try {
            lengthField = this.parseStringFromNextElement();
            length = Integer.parseInt(lengthField);
        }
        catch (EDISyntaxException e) {
            throw new EDISyntaxException("UNO segment missing mandatory length field", this.getTokenizer());
        }
        catch (NumberFormatException e) {
            throw new EDISyntaxException("UNO object length must be numeric instead of " + lengthField, this.getTokenizer());
        }
        String packageReference = this.parseStringFromNextElement();
        if (debug) {
            EdifactReader.trace("UNO length lengthField: " + lengthField + ", object " + packageReference);
        }
        this.getTokenizer().skipSegment();
        char[] dataObject = this.getTokenizer().getChars(length);
        if (debug) {
            EdifactReader.trace("Data object of length " + dataObject.length);
        }
        Token token = this.getTokenizer().nextToken();
        if (debug) {
            EdifactReader.trace("Token after UNO: " + token);
        }
        if (token.getType() == Token.TokenType.SEGMENT_START && "UNP".equals(token.getSegmentType())) {
            int unpLength;
            if (debug) {
                EdifactReader.trace("UNP noted");
            }
            String unpLengthField = this.parseStringFromNextElement();
            try {
                unpLength = Integer.parseInt(unpLengthField);
            }
            catch (NumberFormatException e) {
                throw new EDISyntaxException("UNP object length must be numeric instead of " + unpLengthField);
            }
            if (length != unpLength) {
                throw new EDISyntaxException("UNP segment contains length field that does not match length field in UNO", length, unpLength, this.getTokenizer());
            }
            String unpPackageReference = this.parseStringFromNextElement();
            if (unpPackageReference == null || !unpPackageReference.equals(packageReference)) {
                throw new EDISyntaxException("UNP segment contains package reference that does not match corresponding reference in UNO", packageReference, unpPackageReference, this.getTokenizer());
            }
        } else {
            throw new EDISyntaxException("UNP segment not properly positioned after UNO segment and data object sequence");
        }
        this.getTokenizer().skipSegment();
        this.getDocumentAttributes().clear();
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getIdAttribute(), packageReference);
        this.startElement(this.getXMLTags().getPackageTag(), this.getDocumentAttributes());
        new ContentHandlerBase64Encoder().encode(dataObject, this.getContentHandler());
        this.endElement(this.getXMLTags().getPackageTag());
    }

    private String parseStringFromNextElement() throws IOException, EDISyntaxException {
        String obj;
        List<String> v = this.getTokenizer().nextCompositeElement();
        if (v != null && v.size() > 0 && (obj = v.get(0)) != null) {
            return obj;
        }
        throw new EDISyntaxException("Mandatory element missing", this.getTokenizer());
    }

    @Override
    public void preview() throws EDISyntaxException, IOException {
        char[] buf = this.getTokenizer().lookahead(128);
        if (buf[0] != 'U' || buf[1] != 'N') {
            throw new EDISyntaxException("EDIFACT interchange must begin with UN");
        }
        if (this.isPreviewed()) {
            throw new EDISyntaxException("Internal error: EDIFACT interchange previewed more than once");
        }
        boolean subDelimiterDetermined = false;
        boolean delimiterDetermined = false;
        boolean releaseDetermined = false;
        boolean decimalMarkDetermined = false;
        boolean terminatorDetermined = false;
        boolean terminatorSuffixDetermined = false;
        this.setTerminatorSuffix("");
        if (buf[2] == 'A') {
            this.setSubDelimiter(buf[3]);
            subDelimiterDetermined = true;
            this.setDelimiter(buf[4]);
            delimiterDetermined = true;
            this.setDecimalMark(buf[5]);
            decimalMarkDetermined = true;
            if (buf[6] == ' ') {
                this.setRelease(-1);
            } else {
                this.setRelease(buf[6]);
            }
            releaseDetermined = true;
            if (buf[7] == ' ') {
                this.setRepetitionSeparator('\u0000');
            } else {
                this.setRepetitionSeparator(buf[7]);
            }
            this.setTerminator(buf[8]);
            terminatorDetermined = true;
            terminatorSuffixDetermined = this.shiftUNBoverUNA(buf);
        }
        if (!(releaseDetermined && subDelimiterDetermined && delimiterDetermined && terminatorDetermined && terminatorSuffixDetermined)) {
            this.previewUNB(buf, delimiterDetermined, subDelimiterDetermined, decimalMarkDetermined, releaseDetermined, terminatorDetermined, terminatorSuffixDetermined);
        }
        this.setPreviewed(true);
    }

    private boolean shiftUNBoverUNA(char[] buf) {
        int j;
        boolean terminatorSuffixDetermined = false;
        int nShift = 9;
        for (j = 9; j < 14; ++j) {
            if (Character.isLetter(buf[j])) {
                nShift = j;
                break;
            }
            this.setTerminatorSuffix(this.getTerminatorSuffix() + buf[j]);
            terminatorSuffixDetermined = true;
        }
        for (j = 0; j < buf.length - nShift; ++j) {
            buf[j] = buf[j + nShift];
        }
        return terminatorSuffixDetermined;
    }

    private void previewUNB(char[] buf, boolean delimiterDetermined, boolean subDelimiterDetermined, boolean decimalMarkDetermined, boolean releaseDetermined, boolean terminatorDetermined, boolean terminatorSuffixDetermined) throws EDISyntaxException {
        if (buf[2] != 'B') {
            throw new EDISyntaxException("Required UNB segment not found in EDIFACT interchange");
        }
        switch (buf[7]) {
            case 'B': {
                if (delimiterDetermined || buf[3] != '+') {
                    if (!delimiterDetermined) {
                        this.setDelimiter('\u001d');
                        delimiterDetermined = true;
                    }
                    if (!subDelimiterDetermined) {
                        this.setSubDelimiter('\u001f');
                        subDelimiterDetermined = true;
                    }
                    if (!terminatorDetermined) {
                        this.setTerminator('\u001c');
                        terminatorDetermined = true;
                    }
                    this.setRelease(-1);
                    releaseDetermined = true;
                    this.setRepetitionSeparator('\u0019');
                }
            }
            case 'A': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': {
                if (!delimiterDetermined) {
                    this.setDelimiter('+');
                }
                if (buf[3] != this.getDelimiter()) {
                    throw new EDISyntaxException("Expected data element separator after UNB segment tag");
                }
                if (!terminatorDetermined) {
                    this.setTerminator('\'');
                }
                if (!subDelimiterDetermined) {
                    this.setSubDelimiter(':');
                }
                if (!decimalMarkDetermined) {
                    this.setDecimalMark('.');
                }
                if (releaseDetermined) break;
                this.setRelease(63);
                break;
            }
            default: {
                throw new EDISyntaxException("Unknown Syntax Identifier in UNB segment: " + new String(buf, 4, 4));
            }
        }
        if (!terminatorSuffixDetermined) {
            this.setTerminatorSuffix(this.scanForSuffix(buf, 3));
        }
    }

    protected String scanForSuffix(char[] buffer, int index) {
        StringBuilder suffix = new StringBuilder("");
        for (int i = index; i < buffer.length; ++i) {
            if (buffer[i] != this.getTerminator()) continue;
            for (int j = 1; j < 3; ++j) {
                if (++i >= buffer.length || Character.isLetter(buffer[i])) continue;
                suffix.append(buffer[i]);
            }
            break;
        }
        return suffix.toString();
    }

    public boolean isUNA() {
        return this.witnessedUNA;
    }

    protected void startInterchange(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getInterchangeTag(), attributes);
    }

    protected void endInterchange() throws SAXException {
        this.endElement(this.getXMLTags().getInterchangeTag());
    }

    protected void startSenderAddress(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getAddressTag(), attributes);
    }

    protected void startReceiverAddress(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getAddressTag(), attributes);
    }

    protected void startMessage(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getDocumentTag(), attributes);
    }

    public EdifactData getEdifactData() {
        return this.edifactData;
    }

    public void setEdifactData(EdifactData edifactData) {
        this.edifactData = edifactData;
    }

    public static boolean isValidDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        try {
            sdf.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

