/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.EdifactReader;
import com.berryworks.edireader.tokenizer.Token;
import java.io.IOException;
import org.xml.sax.SAXException;

public class UNHReader
extends EdifactReader {
    @Override
    public void preview() throws EDISyntaxException, IOException {
        this.setDelimiter('+');
        this.setSubDelimiter(':');
        this.setTerminator('\'');
        this.setRelease(63);
        this.setRepetitionSeparator('\u0000');
        this.setDecimalMark('.');
        this.setPreviewed(true);
    }

    @Override
    protected Token parseInterchange(Token token) throws SAXException, IOException {
        if (debug) {
            UNHReader.trace("entering parseInterchange for the UNH variety (UNB/UNZ are omitted) of EDIFACT interchange");
        }
        this.getInterchangeAttributes().clear();
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getStandard(), "EDIFACT-UNH");
        this.setGroupCount(0);
        this.startInterchange(this.getInterchangeAttributes());
        while (true) {
            this.ungExplicit = true;
            if (token.getType() == Token.TokenType.END_OF_DATA) break;
            if (token.getType() != Token.TokenType.SEGMENT_START) {
                throw new EDISyntaxException("Invalid beginning of UNH segment", this.getTokenizer());
            }
            String sType = token.getValue();
            if (!sType.equals("UNH")) break;
            this.impliedFunctionalGroup(token);
        }
        this.endInterchange();
        Token lastToken = this.getTokenizer().skipSegment();
        return lastToken;
    }

    @Override
    protected Token recognizeBeginning() throws IOException, SAXException {
        Token t = this.getTokenizer().nextToken();
        if (t.getType() != Token.TokenType.SEGMENT_START || !"UNH".equals(t.getValue())) {
            throw new EDISyntaxException("The first segment of this type of interchange must be a UNH");
        }
        return t;
    }

    @Override
    protected Token impliedFunctionalGroup(Token token) throws SAXException, IOException {
        this.getGroupAttributes().clear();
        this.startElement(this.getXMLTags().getGroupTag(), this.getGroupAttributes());
        while (token.getType() != Token.TokenType.END_OF_DATA) {
            if (token.getType() != Token.TokenType.SEGMENT_START) {
                throw new EDISyntaxException("Invalid beginning of UNH segment", this.getTokenizer().getSegmentCount());
            }
            String sType = token.getValue();
            if (sType.equals("UNH")) {
                this.setGroupCount(1 + this.getGroupCount());
                this.parseDocument(token);
                token = this.getTokenizer().nextToken();
                continue;
            }
            throw new EDISyntaxException("Unexpected segment type in this context", "UNH", sType, this.getTokenizer());
        }
        this.endElement(this.getXMLTags().getGroupTag());
        return token;
    }
}

