/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EDIAck {
    InputSource inputSource;
    OutputStream ackOutput;
    ContentHandler handler;
    EDIReader parser;
    final String inputFileName;
    final String outputFileName;

    public EDIAck(String input, String output, boolean debug) {
        this.inputFileName = input;
        this.outputFileName = output;
        if (debug) {
            EDIReader.setDebug(true);
        }
        if (this.outputFileName == null) {
            this.ackOutput = System.out;
        } else {
            try {
                this.ackOutput = new BufferedOutputStream(new FileOutputStream(this.outputFileName));
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        }
        try {
            this.inputSource = new InputSource(new FileReader(this.inputFileName));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void run() {
        this.handler = new DefaultHandler();
        char[] leftOver = null;
        PrintWriter ackWriter = new PrintWriter(this.ackOutput);
        try {
            while (true) {
                this.parser = EDIReaderFactory.createEDIReader(this.inputSource, leftOver);
                if (this.parser != null) {
                    this.parser.setContentHandler(this.handler);
                    this.parser.setAcknowledgment(ackWriter);
                    this.parser.parse(this.inputSource);
                    leftOver = this.parser.getTokenizer().getBuffered();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (SAXException e) {
            System.err.println("\nEDI input not well-formed:\n" + e.toString());
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void main(String[] args) {
        String outputFileName = null;
        String inputFileName = null;
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    EDIAck.badArgs();
                }
                outputFileName = args[i];
                continue;
            }
            if (args[i].equals("-d")) {
                debug = true;
                continue;
            }
            inputFileName = args[i];
        }
        if (inputFileName == null) {
            EDIAck.badArgs();
        }
        EDIAck demo = new EDIAck(inputFileName, outputFileName, debug);
        demo.run();
    }

    private static void badArgs() {
        System.out.println("Usage: EDIAck inputFile [-o outputFile] [-d]");
        System.out.println("where:  inputFile      file containing EDI input");
        System.out.println("        -o outputFile  file for acknowledgment output, defaults to stdout");
        System.out.println("        -d             debug mode");
        throw new RuntimeException("Missing or invalid command line arguments");
    }
}

