/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.TransactionCallback;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AnsiTransactionExtractor {
    private InputSource inputSource;

    public AnsiTransactionExtractor(String inputFileName) {
        try {
            this.inputSource = new InputSource(new FileReader(inputFileName));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void run() {
        try {
            EDIReader parser;
            while ((parser = EDIReaderFactory.createEDIReader(this.inputSource)) != null) {
                parser.setTransactionCallback(new MyCallback(parser));
                parser.setContentHandler(new DefaultHandler());
                parser.parse(this.inputSource);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (SAXException e) {
            System.out.println("EDI input not well-formed: " + e.toString());
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            AnsiTransactionExtractor.badArgs();
        }
        AnsiTransactionExtractor demo = new AnsiTransactionExtractor(args[0]);
        demo.run();
    }

    private static void badArgs() {
        System.out.println("Usage: AnsiTransactionExtractor inputfile");
        throw new RuntimeException("Missing or invalid command line arguments");
    }

    static class MyCallback
    implements TransactionCallback {
        private final EDIReader parser;
        StringWriter stringWriter;

        public MyCallback(EDIReader parser) {
            this.parser = parser;
        }

        @Override
        public void startTransaction(String segmentType) {
            this.stringWriter = new StringWriter();
            this.stringWriter.write(segmentType);
            this.parser.setCopyWriter(this.stringWriter);
        }

        @Override
        public void endTransaction() {
            this.parser.setCopyWriter(null);
            String transactionString = this.stringWriter.toString();
            System.out.println("--- ST/SE Sequence ----------------------");
            System.out.println(transactionString);
            System.out.println("-----------------------------------------");
        }
    }
}

