/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.plugin;

public class LoopDescriptor {
    protected final String name;
    protected final String firstSegment;
    protected final int nestingLevel;
    protected final String loopContext;
    private final int levelContext;

    public LoopDescriptor(String loopName, String firstSegment, int nestingLevel, String currentLoop) {
        this.name = loopName;
        this.firstSegment = firstSegment;
        this.nestingLevel = nestingLevel;
        this.loopContext = currentLoop;
        this.levelContext = -1;
    }

    public LoopDescriptor(String loopName, String firstSegment, int nestingLevel) {
        this(loopName, firstSegment, nestingLevel, "*");
    }

    public LoopDescriptor(String loopName, String firstSegment) {
        this(loopName, firstSegment, 1, "/");
    }

    public LoopDescriptor(String loopName, String firstSegment, int nestingLevel, int currentLevel) {
        this.name = loopName;
        this.firstSegment = firstSegment;
        this.nestingLevel = nestingLevel;
        this.loopContext = "*";
        this.levelContext = currentLevel;
    }

    public String getName() {
        return this.name;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }

    public String getLoopContext() {
        return this.loopContext;
    }

    public int getLevelContext() {
        return this.levelContext;
    }

    public String getFirstSegment() {
        return this.firstSegment;
    }

    public String toString() {
        String result = "loop " + this.getName() + " at nesting level " + this.getNestingLevel() + ": encountering segment " + this.getFirstSegment();
        String context = this.getLoopContext();
        result = "*".equals(context) ? result + " anytime" : ("/".equals(context) ? result + " while outside any loop" : result + " while currently in loop " + context);
        if (this.levelContext > -1) {
            result = result + " while current at nesting level " + this.levelContext;
        }
        return result;
    }

    public boolean equals(Object target) {
        if (!(target instanceof LoopDescriptor)) {
            return false;
        }
        LoopDescriptor sld = (LoopDescriptor)target;
        return this.equalsOrBothNull(this.getName(), sld.getName()) && this.equalsOrBothNull(this.getFirstSegment(), sld.getFirstSegment()) && this.getNestingLevel() == sld.getNestingLevel() && this.getLoopContext().equals(sld.getLoopContext()) && this.getLevelContext() == sld.getLevelContext();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getFirstSegment().hashCode();
    }

    private boolean equalsOrBothNull(String value1, String value2) {
        return value1 == null && value2 == null || value1 != null && value1.equals(value2);
    }

    public boolean isAnyContext() {
        return "*".equals(this.loopContext);
    }
}

