/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommandLine {
    private final Map<String, String> optionMap = new HashMap<String, String>();
    private final List<String> positionalArgs = new ArrayList<String>();

    public CommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                String option = arg.substring(1);
                if (++i < args.length) {
                    String value = args[i];
                    this.optionMap.put(option, value);
                    continue;
                }
                this.badArgs("missing value for option " + option);
                continue;
            }
            this.positionalArgs.add(args[i]);
        }
    }

    public void badArgs(String msg) {
        System.err.println("Invalid command line argument(s): " + msg);
        System.err.println("");
        System.err.println(this.usage());
    }

    public String usage() {
        return "";
    }

    public int size() {
        return this.optionMap.size() + this.positionalArgs.size();
    }

    public boolean isPresent(String arg) {
        return this.optionMap.get(arg) != null;
    }

    public String getOption(String arg) {
        return this.optionMap.get(arg);
    }

    public String getPosition(int i) {
        return this.positionalArgs.size() > i ? this.positionalArgs.get(i) : null;
    }

    public int getPositionAsInt(int i) {
        String value = this.getPosition(i);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid integer argument at position " + i;
            this.badArgs(msg);
            throw new RuntimeException(msg);
        }
    }

    public String getPosition(int i, String defaultValue) {
        if (this.positionalArgs.size() > i) {
            String value = this.positionalArgs.get(i);
            return value == null || value.length() == 0 ? defaultValue : value;
        }
        if (defaultValue == null) {
            String msg = "Required argument missing at position " + i;
            this.badArgs(msg);
            throw new RuntimeException(msg);
        }
        return defaultValue;
    }

    public int getAsInt(String option) {
        String value = this.getOption(option);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid integer value for option " + value;
            this.badArgs(msg);
            throw new RuntimeException(msg);
        }
    }
}

