/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.base64;

import com.berryworks.edireader.util.base64.AbstractDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class StringBase64Decoder
extends AbstractDecoder {
    private final StringBuilder stringBuffer = new StringBuilder();
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(100);

    @Override
    protected void emit(byte b) {
        if (!this.byteBuffer.hasRemaining()) {
            this.feedStringBuffer();
            this.byteBuffer.clear();
        }
        this.byteBuffer.put(b);
    }

    private void feedStringBuffer() {
        this.byteBuffer.flip();
        this.stringBuffer.append(charset.decode(this.byteBuffer));
    }

    public String decodeAsString(String encodedText) {
        CharBuffer charBuffer = CharBuffer.wrap(encodedText);
        ByteBuffer base64ByteBuffer = ByteBuffer.allocate(100);
        CharsetEncoder encoder = charset.newEncoder();
        while (true) {
            CoderResult coderResult;
            if ((coderResult = encoder.encode(charBuffer, base64ByteBuffer, true)).isError()) {
                throw new RuntimeException("Unrecoverable failure in Base64 encoding");
            }
            base64ByteBuffer.flip();
            while (base64ByteBuffer.hasRemaining()) {
                this.consume(base64ByteBuffer.get());
            }
            if (coderResult.isUnderflow()) break;
            base64ByteBuffer.clear();
        }
        this.endOfData();
        this.feedStringBuffer();
        return this.stringBuffer.toString();
    }
}

