/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import ar.com.sdd.edireader.model.EdifactData;
import com.berryworks.edireader.DefaultXMLTags;
import com.berryworks.edireader.EDIAbstractReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.XMLTags;
import com.berryworks.edireader.error.ErrorMessages;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EDIReader
extends EDIAbstractReader
implements ErrorMessages {
    public static boolean debug;
    private EDIReader theReader;
    private XMLTags xmlTags;

    public EDIReader() {
        if (Boolean.getBoolean("edireader.debug")) {
            EDIReader.setDebug(true);
        }
    }

    @Override
    public void preview() throws EDISyntaxException, IOException {
        throw new EDISyntaxException("EDIReader.preview() called unexpectedly");
    }

    @Override
    public void parse(InputSource source) throws SAXException, IOException {
        this.edifactData = new EdifactData();
        this.startXMLDocument();
        char[] leftOver = null;
        while (true) {
            if (this.theReader == null) {
                this.theReader = EDIReaderFactory.createEDIReader(source, leftOver);
                if (this.theReader == null) {
                    if (!debug) break;
                    EDIReader.trace("EDIReader.parse(InputSource) hit end of input");
                    break;
                }
                if (debug) {
                    EDIReader.trace("EDIReader.parse(InputSource) created an EDIReader of type " + this.theReader.getClass().getName());
                }
                this.theReader.setExternalXmlDocumentStart(true);
                this.theReader.setAcknowledgment(this.getAckStream());
                this.theReader.setContentHandler(this.getContentHandler());
                this.theReader.setSyntaxExceptionHandler(this.getSyntaxExceptionHandler());
                this.theReader.setNamespaceEnabled(this.isNamespaceEnabled());
            }
            this.theReader.setXMLTags(this.xmlTags);
            this.theReader.parse(source);
            this.setDelimiter(this.theReader.getDelimiter());
            this.setSubDelimiter(this.theReader.getSubDelimiter());
            this.setTerminator(this.theReader.getTerminator());
            this.setTerminatorSuffix(this.theReader.getTerminatorSuffix());
            leftOver = this.theReader.getTokenizer().getBuffered();
            this.theReader = null;
        }
        this.endXMLDocument();
    }

    public void setXMLTags(XMLTags tags) {
        this.xmlTags = tags;
    }

    public XMLTags getXMLTags() {
        if (this.xmlTags == null) {
            this.xmlTags = DefaultXMLTags.getInstance();
        }
        return this.xmlTags;
    }

    public static void setDebug(boolean d) {
        if (debug && d) {
            EDIReader.trace("Debug already on");
        } else if (!debug && d) {
            EDIReader.trace("Debug turned on");
        } else if (debug && !d) {
            EDIReader.trace("Debug turned off");
        }
        debug = d;
    }

    protected void startXMLDocument() throws SAXException {
        AttributesImpl attrList = new AttributesImpl();
        attrList.clear();
        this.getContentHandler().startDocument();
        if (this.isNamespaceEnabled()) {
            String rootTag = this.getXMLTags().getRootTag();
            this.getContentHandler().startElement("http://www.berryworkssoftware.com/2008/edireader", rootTag, rootTag, attrList);
        } else {
            this.startElement(this.getXMLTags().getRootTag(), attrList);
        }
    }

    protected void endXMLDocument() throws SAXException {
        this.endElement(this.getXMLTags().getRootTag());
        this.getContentHandler().endDocument();
    }

    protected void startElement(String tag, Attributes attributes) throws SAXException {
        this.getContentHandler().startElement("", tag, tag, attributes);
    }

    protected void endElement(String tag) throws SAXException {
        this.getContentHandler().endElement("", tag, tag);
    }
}

