/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EDIAbstractReader;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.ParserRegistry;
import com.berryworks.edireader.tokenizer.EDITokenizer;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.InputSource;

public class EDIReaderFactory {
    public static EDIReader createEDIReader(InputSource source) throws EDISyntaxException, IOException {
        return EDIReaderFactory.createEDIReader(source, null, false);
    }

    public static EDIReader createEDIReader(InputSource source, boolean debug) throws EDISyntaxException, IOException {
        return EDIReaderFactory.createEDIReader(source, null, debug);
    }

    public static EDIReader createEDIReader(InputSource source, char[] preRead) throws EDISyntaxException, IOException {
        return EDIReaderFactory.createEDIReader(source, preRead, false);
    }

    public static EDIReader createEDIReader(InputSource source, char[] preRead, boolean debug) throws EDISyntaxException, IOException {
        Reader inputReader = EDIAbstractReader.createReader(source);
        EDITokenizer tokenizer = preRead == null || preRead.length == 0 ? new EDITokenizer(inputReader) : new EDITokenizer(inputReader, preRead);
        tokenizer.scanTerminatorSuffix();
        if (tokenizer.isEndOfData()) {
            return null;
        }
        char[] buf = tokenizer.lookahead(3);
        if (buf == null || buf.length < 3) {
            throw new RuntimeException("tokenizer.lookahead() returned null");
        }
        String asString = new String(buf);
        EDIReader parser = ParserRegistry.get(asString);
        if (parser == null) {
            throw new EDISyntaxException("No supported EDI standard interchange begins with " + asString);
        }
        if (debug) {
            EDIReaderFactory.trace("parser constructed of type " + parser.getClass().getName());
        }
        source.setCharacterStream(inputReader);
        parser.setTokenizer(tokenizer);
        parser.preview();
        return parser;
    }

    protected static void trace(String string) {
        EDIAbstractReader.trace(string);
    }
}

