package ar.com.sdd.edireader.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

public class EdifactData implements Serializable {

    private Long id;
    private Long payerCuit;
    private String ownerCuit;
    private String legalDocRef;
    private LocalDate issueDate;
    private LocalDate dueDate;
    private LocalDate creationDate;
    private LocalDate startActivities; //Representa el inicio de las actividades de una empresa
    private LocalDate deliveryDate;
    private double totalAmount;
    private double dueAmount;
    private double payableAmountNoTax;
    private double totalTaxAmount;
    private List<EdifactItem> edifactItems;


    private String  biltoName;
    private String  billingAddress;
    private String  shiptoName;
    private String  shippingAddress;


    public EdifactData() {

    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPayerCuit() {
        return payerCuit;
    }

    public void setPayerCuit(Long payerCuit) {
        this.payerCuit = payerCuit;
    }

    public String getOwnerCuit() {
        return ownerCuit;
    }

    public void setOwnerCuit(String ownerCuit) {
        this.ownerCuit = ownerCuit;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public LocalDate getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(LocalDate issueDate) {
        this.issueDate = issueDate;
    }

    public LocalDate getDueDate() {
        return dueDate;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
    }

    public LocalDate getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDate getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(LocalDate deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public double getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(double dueAmount) {
        this.dueAmount = dueAmount;
    }

    public double getPayableAmountNoTax() {
        return payableAmountNoTax;
    }

    public void setPayableAmountNoTax(double payableAmountNoTax) {
        this.payableAmountNoTax = payableAmountNoTax;
    }

    public double getTotalTaxAmount() {
        return totalTaxAmount;
    }

    public void setTotalTaxAmount(double totalTaxAmount) {
        this.totalTaxAmount = totalTaxAmount;
    }

    public List<EdifactItem> getEdifactItems() {
        return edifactItems;
    }

    public void setEdifactItems(List<EdifactItem> edifactItems) {
        this.edifactItems = edifactItems;
    }

    public String getBiltoName() {
        return biltoName;
    }

    public void setBiltoName(String biltoName) {
        this.biltoName = biltoName;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getShiptoName() {
        return shiptoName;
    }

    public void setShiptoName(String shiptoName) {
        this.shiptoName = shiptoName;
    }

    public String getShippingAddress() {
        return shippingAddress;
    }

    public void setShippingAddress(String shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public LocalDate getStartActivities() {
        return startActivities;
    }

    public void setStartActivities(LocalDate startActivities) {
        this.startActivities = startActivities;
    }

    @Override
    public String toString() {
        return "EdifactData ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((payerCuit != null) ? "payerCuit=" + payerCuit + ", " : "")
                + ((ownerCuit != null) ? "ownerCuit=" + ownerCuit + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate + ", " : "")
                + ((creationDate != null) ? "creationDate=" + creationDate + ", " : "")
                + ((startActivities != null) ? "startActivities=" + startActivities + ", " : "")
                + ((deliveryDate != null) ? "deliveryDate=" + deliveryDate + ", " : "")
                + "totalAmount=" + totalAmount + ", "
                + "dueAmount=" + dueAmount + ", "
                + "payableAmountNoTax=" + payableAmountNoTax + ", "
                + "totalTaxAmount=" + totalTaxAmount + ", "
                + ((edifactItems != null) ? "edifactItems=" + Arrays.toString(edifactItems.toArray()) + ", " : "")
                + ((biltoName != null) ? "biltoName=" + biltoName + ", " : "")
                + ((billingAddress != null) ? "billingAddress=" + billingAddress + ", " : "")
                + ((shiptoName != null) ? "shiptoName=" + shiptoName + ", " : "")
                + ((shippingAddress != null) ? "shippingAddress=" + shippingAddress : "")
                + "]";
    }
}
