/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.base64;

import com.berryworks.edireader.util.base64.AbstractEncoderDecoder;
import com.berryworks.edireader.util.base64.EncoderBackEnd;
import com.berryworks.edireader.util.base64.EncoderFrontEnd;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;

public abstract class AbstractEncoder
extends AbstractEncoderDecoder {
    private final EncoderFrontEnd frontEnd = new EncoderFrontEnd(){

        @Override
        protected void emit(byte value) {
            AbstractEncoder.this.backEnd.consume(value);
        }

        @Override
        protected void endOfData() {
            AbstractEncoder.this.backEnd.endOfData();
        }
    };
    private final EncoderBackEnd backEnd;
    private static final int BUFFER_SIZE = 1000;

    public AbstractEncoder() {
        final AbstractEncoder thisEncoder = this;
        this.backEnd = new EncoderBackEnd(){

            @Override
            protected void emit(byte b) {
                thisEncoder.emit(b);
            }
        };
    }

    @Override
    public void consume(byte b) {
        this.frontEnd.consume(b);
    }

    @Override
    protected void endOfData() {
        this.frontEnd.endOfData();
    }

    /*
     * Unable to fully structure code
     */
    public void encode(InputStream inputStream) throws IOException {
        this.reset();
        buffer = new byte[1000];
        while (true) {
            if ((n = inputStream.read(buffer)) < 0) break;
            if (n <= 0) continue;
            i = 0;
            while (true) {
                if (i >= n) ** break;
                this.consume(buffer[i]);
                ++i;
            }
            break;
        }
        this.endOfData();
    }

    public void encode(byte[] bytes) {
        this.reset();
        for (byte aByte : bytes) {
            this.consume(aByte);
        }
        this.endOfData();
    }

    public void encode(String s) {
        CharBuffer charBuffer = CharBuffer.wrap(s);
        this.encode(charset.encode(charBuffer).array());
    }

    @Override
    protected void reset() {
        this.frontEnd.reset();
        this.backEnd.reset();
    }
}

