/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import ar.com.sdd.edireader.model.EdifactData;
import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.SyntaxDescriptor;
import com.berryworks.edireader.TransactionCallback;
import com.berryworks.edireader.error.EDISyntaxExceptionHandler;
import com.berryworks.edireader.tokenizer.EDITokenizer;
import com.berryworks.edireader.tokenizer.Tokenizer;
import com.berryworks.edireader.util.BranchingWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class EDIAbstractReader
implements XMLReader {
    protected static final String BERRYWORKS_NAMESPACE = "http://www.berryworkssoftware.com/2008/edireader";
    private ContentHandler contentHandler;
    private Tokenizer tokenizer;
    private EDISyntaxExceptionHandler syntaxExceptionHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private char delimiter;
    private char subDelimiter;
    private char subSubDelimiter;
    private char decimalMark;
    private char repetitionSeparator;
    private char terminator;
    private int release;
    private String terminatorSuffix;
    private BranchingWriter ackStream;
    private boolean interchangeAcknowledgment;
    private Writer copyWriter;
    private String firstSegment;
    private final EDIAttributes interchangeAttributes = new EDIAttributes();
    private final EDIAttributes noAttributes = new EDIAttributes();
    private final EDIAttributes groupAttributes = new EDIAttributes();
    private final EDIAttributes documentAttributes = new EDIAttributes();
    private boolean previewed;
    private boolean externalXmlDocumentStart;
    private boolean namespaceEnabled;
    private SyntaxDescriptor acknowledgmentSyntaxDescriptor;
    private TransactionCallback transactionCallback;
    protected EdifactData edifactData;

    public char getTerminator() {
        return this.terminator;
    }

    public String getTerminatorSuffix() {
        return this.terminatorSuffix;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setSubDelimiter(char subDelimiter) {
        this.subDelimiter = subDelimiter;
    }

    public void setSubSubDelimiter(char subSubDelimiter) {
        this.subSubDelimiter = subSubDelimiter;
    }

    public void setDecimalMark(char decimalMark) {
        this.decimalMark = decimalMark;
    }

    public void setRepetitionSeparator(char repetitionSeparator) {
        this.repetitionSeparator = repetitionSeparator;
    }

    public void setTerminator(char terminator) {
        this.terminator = terminator;
    }

    public void setRelease(int release) {
        this.release = release;
    }

    public void setTerminatorSuffix(String terminatorSuffix) {
        this.terminatorSuffix = terminatorSuffix;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public char getSubDelimiter() {
        return this.subDelimiter;
    }

    public int getRelease() {
        return this.release;
    }

    public char getReleaseCharacter() {
        return this.isReleaseCharacterDefined() ? (char)this.release : (char)' ';
    }

    public boolean isReleaseCharacterDefined() {
        return this.release != -1;
    }

    public char getDecimalMark() {
        return this.decimalMark;
    }

    public char getSubSubDelimiter() {
        return this.subSubDelimiter;
    }

    public char getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(Tokenizer t) {
        this.tokenizer = t;
        if (EDIReader.debug) {
            EDIAbstractReader.trace("EDIAbstractReader.setTokenizer(" + (t == null ? "null" : "non-null") + ")");
        }
    }

    public void setCopyWriter(Writer writer) {
        if (this.tokenizer != null) {
            this.tokenizer.setWriter(writer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Reader createReader(InputSource source) throws IOException {
        if (source == null) {
            throw new IOException("createReader called with null InputSource");
        }
        Reader inputReader = source.getCharacterStream();
        if (inputReader != null) return inputReader;
        InputStream inputStream = source.getByteStream();
        if (inputStream != null) {
            return new InputStreamReader(inputStream);
        }
        String systemId = source.getSystemId();
        if (systemId == null) throw new IOException("Cannot get ByteStream, CharacterStream, or SystemId from EDI InputSource");
        if (!systemId.startsWith("file:")) throw new IOException("InputSource using SystemId (" + systemId + ") not yet supported");
        return new FileReader(systemId.substring(5));
    }

    protected void parseSetup(InputSource source) throws EDISyntaxException, IOException {
        if (EDIReader.debug) {
            EDIAbstractReader.trace("EDIAbstractReader.parseSetup()");
        }
        Reader inputReader = EDIAbstractReader.createReader(source);
        if (this.tokenizer == null) {
            this.setTokenizer(new EDITokenizer(inputReader));
            if (EDIReader.debug) {
                EDIAbstractReader.trace("Constructed new tokenizer because this reader did not have one");
            }
        } else if (EDIReader.debug) {
            EDIAbstractReader.trace("Reusing existing tokenizer");
        }
        if (!this.previewed) {
            if (EDIReader.debug) {
                EDIAbstractReader.trace("EDIAbstractReader: not yet previewed");
            }
            this.preview();
            this.previewed = true;
        }
        if (this.copyWriter != null) {
            this.tokenizer.setWriter(this.copyWriter);
        }
        if (EDIReader.debug) {
            EDIAbstractReader.trace("parseSetup completed");
        }
    }

    public abstract void preview() throws EDISyntaxException, IOException;

    public void setAcknowledgment(Writer writer) {
        this.ackStream = writer == null ? null : new BranchingWriter(writer);
    }

    public void setAcknowledgment(Writer writer, SyntaxDescriptor syntaxDescriptor) {
        this.setAcknowledgment(writer);
        this.setAcknowledgmentSyntaxDescriptor(syntaxDescriptor);
    }

    public boolean isInterchangeAcknowledgment() {
        return this.interchangeAcknowledgment;
    }

    public void setInterchangeAcknowledgment(boolean interchangeAcknowledgment) {
        this.interchangeAcknowledgment = interchangeAcknowledgment;
    }

    public SyntaxDescriptor getAcknowledgmentSyntaxDescriptor() {
        return this.acknowledgmentSyntaxDescriptor;
    }

    public void setAcknowledgmentSyntaxDescriptor(SyntaxDescriptor syntaxDescriptor) {
        this.acknowledgmentSyntaxDescriptor = syntaxDescriptor;
    }

    public TransactionCallback getTransactionCallback() {
        return this.transactionCallback;
    }

    public void setTransactionCallback(TransactionCallback transactionCallback) {
        this.transactionCallback = transactionCallback;
    }

    public EDISyntaxExceptionHandler getSyntaxExceptionHandler() {
        return this.syntaxExceptionHandler;
    }

    public void setSyntaxExceptionHandler(EDISyntaxExceptionHandler syntaxExceptionHandler) {
        this.syntaxExceptionHandler = syntaxExceptionHandler;
    }

    public boolean isNamespaceEnabled() {
        return this.namespaceEnabled;
    }

    public void setNamespaceEnabled(boolean namespaceEnabled) {
        this.namespaceEnabled = namespaceEnabled;
    }

    public boolean isExternalXmlDocumentStart() {
        return this.externalXmlDocumentStart;
    }

    public void setExternalXmlDocumentStart(boolean externalXmlDocumentStart) {
        this.externalXmlDocumentStart = externalXmlDocumentStart;
    }

    public void setLocale(Locale locale) throws SAXException {
        throw new SAXNotSupportedException("setLocale not supported");
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void parse(String systemId) throws SAXException, IOException {
        throw new SAXException("parse(systemId) not supported");
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("Not yet implemented");
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("Not yet implemented");
    }

    public EDIAttributes getDocumentAttributes() {
        return this.documentAttributes;
    }

    public EDIAttributes getInterchangeAttributes() {
        return this.interchangeAttributes;
    }

    public EDIAttributes getGroupAttributes() {
        return this.groupAttributes;
    }

    public BranchingWriter getAckStream() {
        return this.ackStream;
    }

    public void setAckStream(BranchingWriter ackStream) {
        this.ackStream = ackStream;
    }

    public boolean isPreviewed() {
        return this.previewed;
    }

    public void setPreviewed(boolean previewed) {
        this.previewed = previewed;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public int getCharCount() {
        return this.tokenizer == null ? 0 : this.tokenizer.getCharCount();
    }

    public int getSegmentCharCount() {
        return this.tokenizer == null ? 0 : this.tokenizer.getSegmentCharCount();
    }

    public String getFirstSegment() {
        return this.firstSegment;
    }

    public void setFirstSegment(String firstSegment) {
        this.firstSegment = firstSegment;
    }

    public static void trace(String msg) {
        System.err.println(msg);
    }

    protected static void trace(Exception e) {
        System.err.println(e.toString());
    }

    public String toString() {
        String lineBreak = System.getProperty("line.separator");
        return lineBreak + "EDIReader summary:" + lineBreak + " class: " + this.getClass().getName() + lineBreak + " delimiter: " + this.getDelimiter() + lineBreak + " subDelimiter: " + this.getSubDelimiter() + lineBreak + " subSubDelimiter: " + this.getSubSubDelimiter() + lineBreak + " repetitionSeparator: " + this.getRepetitionSeparator() + lineBreak + " terminator: " + this.getTerminator() + lineBreak + " terminatorSuffix: " + this.getTerminatorSuffix() + lineBreak + " charCount: " + this.getCharCount() + lineBreak + " segmentCharCount: " + this.getSegmentCharCount() + lineBreak;
    }

    public static boolean isPresent(String value) {
        return value != null && value.length() > 0;
    }

    public static String emptyStringIfNull(String value) {
        return value == null ? "" : value;
    }

    public EdifactData getEdifactData() {
        return this.edifactData;
    }
}

