/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import ar.com.sdd.edireader.model.EdifactData;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.ReplyGenerator;
import com.berryworks.edireader.error.RecoverableSyntaxException;
import com.berryworks.edireader.tokenizer.Token;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class StandardReader
extends EDIReader {
    private String interchangeControlNumber;
    private String groupControlNumber;
    private int groupCount;
    private int documentCount;
    private ReplyGenerator ackGenerator;
    private RecoverableSyntaxException syntaxException;

    protected abstract Token recognizeBeginning() throws IOException, SAXException;

    protected abstract Token parseInterchange(Token var1) throws SAXException, IOException;

    @Override
    public void parse(InputSource source) throws SAXException, IOException {
        this.edifactData = new EdifactData();
        if (source == null) {
            throw new IOException("parse called with null InputSource");
        }
        if (this.getContentHandler() == null) {
            throw new IOException("parse called with null ContentHandler");
        }
        if (!this.isExternalXmlDocumentStart()) {
            this.startXMLDocument();
        }
        this.parseSetup(source);
        this.getTokenizer().setDelimiter(this.getDelimiter());
        this.getTokenizer().setSubDelimiter(this.getSubDelimiter());
        this.getTokenizer().setRelease(this.getRelease());
        this.getTokenizer().setRepetitionSeparator(this.getRepetitionSeparator());
        this.getTokenizer().setTerminator(this.getTerminator());
        try {
            this.parseInterchange(this.recognizeBeginning());
        }
        catch (EDISyntaxException e) {
            if (this.ackGenerator != null) {
                this.ackGenerator.generateNegativeACK();
            }
            throw e;
        }
        if (!this.isExternalXmlDocumentStart()) {
            this.endXMLDocument();
        }
    }

    protected void parseSegmentElement(Token t) throws SAXException {
        String elementId = t.getElementId();
        String value = t.getValue().trim();
        this.getDocumentAttributes().clear();
        if (t.getType() == Token.TokenType.SIMPLE) {
            if (value.length() == 0) {
                return;
            }
            this.getDocumentAttributes().addCDATA(this.getXMLTags().getIdAttribute(), elementId);
            this.startElement(this.getXMLTags().getElementTag(), this.getDocumentAttributes());
            char[] cv = t.getValueChars();
            this.getContentHandler().characters(cv, 0, cv.length);
            this.endElement(this.getXMLTags().getElementTag());
        } else if (t.getType() == Token.TokenType.SUB_ELEMENT || t.getType() == Token.TokenType.SUB_EMPTY) {
            if (t.isFirst()) {
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getIdAttribute(), elementId);
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getCompositeIndicator(), "yes");
                this.startElement(this.getXMLTags().getElementTag(), this.getDocumentAttributes());
            }
            if (t.getType() == Token.TokenType.SUB_ELEMENT) {
                this.getDocumentAttributes().clear();
                this.getDocumentAttributes().addAttribute("", this.getXMLTags().getSubElementSequence(), this.getXMLTags().getSubElementSequence(), "CDATA", String.valueOf(1 + t.getSubIndex()));
                this.startElement(this.getXMLTags().getSubElementTag(), this.getDocumentAttributes());
                char[] cv = t.getValueChars();
                this.getContentHandler().characters(cv, 0, cv.length);
                this.endElement(this.getXMLTags().getSubElementTag());
            }
            if (t.isLast()) {
                this.endElement(this.getXMLTags().getElementTag());
            }
        }
    }

    public void setControlDateAndTime(String overrideValue) {
        this.getAckGenerator().setControlDateAndTime(overrideValue);
    }

    protected boolean recover(RecoverableSyntaxException e) {
        return this.getSyntaxExceptionHandler() != null && this.getSyntaxExceptionHandler().process(e);
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(int groupCount) {
        this.groupCount = groupCount;
    }

    public String getInterchangeControlNumber() {
        return this.interchangeControlNumber;
    }

    public void setInterchangeControlNumber(String interchangeControlNumber) {
        this.interchangeControlNumber = interchangeControlNumber;
    }

    public String getGroupControlNumber() {
        return this.groupControlNumber;
    }

    public void setGroupControlNumber(String groupControlNumber) {
        this.groupControlNumber = groupControlNumber;
    }

    public int getDocumentCount() {
        return this.documentCount;
    }

    public void setDocumentCount(int documentCount) {
        this.documentCount = documentCount;
    }

    public RecoverableSyntaxException getSyntaxException() {
        return this.syntaxException;
    }

    public void setSyntaxException(RecoverableSyntaxException syntaxException) {
        this.syntaxException = syntaxException;
    }

    public ReplyGenerator getAckGenerator() {
        return this.ackGenerator;
    }

    public void setAckGenerator(ReplyGenerator ackGenerator) {
        this.ackGenerator = ackGenerator;
    }

    protected void parseSegment(PluginController pluginController, String segmentType) throws SAXException, IOException {
        Token t;
        if (pluginController.transition(segmentType)) {
            int toClose = pluginController.closedCount();
            if (debug) {
                StandardReader.trace("closing " + toClose + " loops");
            }
            while (toClose > 0) {
                this.endElement(this.getXMLTags().getLoopTag());
                --toClose;
            }
            String s = pluginController.getLoopEntered();
            if (!pluginController.isResumed()) {
                this.getDocumentAttributes().clear();
                this.getDocumentAttributes().addCDATA(this.getXMLTags().getIdAttribute(), s);
                this.startElement(this.getXMLTags().getLoopTag(), this.getDocumentAttributes());
            }
        }
        this.getDocumentAttributes().clear();
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getIdAttribute(), segmentType);
        this.startElement(this.getXMLTags().getSegTag(), this.getDocumentAttributes());
        while ((t = this.getTokenizer().nextToken()).getType() != Token.TokenType.SEGMENT_END) {
            switch (t.getType()) {
                case SIMPLE: 
                case EMPTY: 
                case SUB_ELEMENT: 
                case SUB_EMPTY: {
                    break;
                }
                case END_OF_DATA: {
                    throw new EDISyntaxException("Unexpected end of data", this.getTokenizer());
                }
                default: {
                    throw new EDISyntaxException("Malformed EDI segment", this.getTokenizer());
                }
            }
            this.parseSegmentElement(t);
        }
        this.endElement(this.getXMLTags().getSegTag());
    }
}

