/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.formatter;

import com.berryworks.edireader.formatter.FormatterParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class Formatter {
    protected Reader input;
    protected PrintWriter output;
    private String ediFilename;

    public Formatter(String inputFilename, String outputFilename) {
        if (inputFilename != null) {
            try {
                this.input = new FileReader(inputFilename);
            }
            catch (IOException e) {
                System.err.println("Unable to open input file " + inputFilename);
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.input = new InputStreamReader(System.in);
        }
        if (outputFilename != null) {
            try {
                this.output = new PrintWriter(new FileWriter(outputFilename));
            }
            catch (IOException e) {
                System.err.println("Unable to open output file " + outputFilename);
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.output = new PrintWriter(System.out, true);
        }
    }

    public Formatter(Reader input, PrintWriter output) {
        this.input = input;
        this.output = output;
    }

    public int format() throws IOException {
        PipedReader pipedReaderA = new PipedReader();
        PipedWriter pipedWriterA = new PipedWriter(pipedReaderA);
        PipedReader pipedReaderB = new PipedReader();
        PipedWriter pipedWriterB = new PipedWriter(pipedReaderB);
        FormatterParser parser = this.createFormatterParser(pipedReaderA, pipedReaderB, this.output);
        Thread thread = new Thread(parser);
        thread.start();
        int count = this.tee(this.input, pipedWriterA, pipedWriterB);
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return count;
    }

    protected int tee(Reader source, Writer destinationA, Writer destinationB) throws IOException {
        char[] buffer = new char[1000];
        int count = 0;
        while (true) {
            int n;
            block5: {
                if ((n = source.read(buffer)) > 0) {
                    try {
                        destinationB.write(buffer, 0, n);
                        destinationB.flush();
                        Thread.yield();
                        destinationA.write(buffer, 0, n);
                        destinationA.flush();
                        break block5;
                    }
                    catch (IOException e) {
                        System.out.println(this.getClass().getName() + ": caught " + e.getMessage());
                        break;
                    }
                }
                if (n < 0) {
                    destinationB.close();
                    destinationA.close();
                    break;
                }
            }
            Thread.yield();
            count += n;
        }
        return count;
    }

    protected FormatterParser createFormatterParser(Reader pipedReaderA, Reader pipedReaderB, PrintWriter out) {
        return new FormatterParser(pipedReaderA, pipedReaderB, out);
    }

    protected String getFilename() {
        return this.ediFilename;
    }

    public void setFilename(String filename) {
        this.ediFilename = filename;
    }

    public static void main(String[] args) {
        String outputFileName = null;
        String inputFileName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-o")) {
                if (++i >= args.length) {
                    Formatter.badArgs();
                }
                outputFileName = args[i];
                continue;
            }
            inputFileName = args[i];
        }
        Formatter formatter = new Formatter(inputFileName, outputFileName);
        try {
            formatter.format();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static void badArgs() {
        System.out.println("Usage: Formatter [-o outputfile] [inputfile]");
        throw new RuntimeException("Missing or invalid command line arguments");
    }
}

