/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.dom;

import com.berryworks.edireader.util.dom.AbstractElementList;
import java.util.ListIterator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathElements
extends AbstractElementList {
    protected final XPath xPath = XPathFactory.newInstance().newXPath();
    private NodeList nodeList;

    public XPathElements(Node node, String path) throws XPathExpressionException {
        this.nodeList = (NodeList)this.xPath.evaluate(path, node, XPathConstants.NODESET);
    }

    @Override
    public ListIterator<Element> listIterator(int index) {
        if (index != 0) {
            throw new RuntimeException("index was " + index + " instead of 0 as expected");
        }
        return new ElementListIterator(this.nodeList);
    }

    private class ElementListIterator
    extends AbstractElementList.AbstractElementListIterator {
        private final NodeList nodeList;
        private Element next;
        private int indexOfNext;

        public ElementListIterator(NodeList nodeList) {
            this.nodeList = nodeList;
            this.indexOfNext = -1;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Element next() {
            Element result = this.next;
            this.next = null;
            if (this.nodeList != null) {
                for (int i = this.indexOfNext + 1; i < this.nodeList.getLength(); ++i) {
                    Node node = this.nodeList.item(i);
                    if (!(node instanceof Element)) continue;
                    this.next = (Element)node;
                    this.indexOfNext = i;
                    break;
                }
            }
            if (this.next == null) {
                this.indexOfNext = -1;
            }
            return result;
        }
    }
}

