/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import com.berryworks.edireader.util.sax.SAXCharacters;
import com.berryworks.edireader.util.sax.SAXEndDocument;
import com.berryworks.edireader.util.sax.SAXEndElement;
import com.berryworks.edireader.util.sax.SAXEndOfStreamMarker;
import com.berryworks.edireader.util.sax.SAXStartDocument;
import com.berryworks.edireader.util.sax.SAXStartElement;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXObjectHandler
extends DefaultHandler {
    private ObjectOutputStream objectStream;
    private int sAXEventsWritten;
    private boolean disabled;

    public SAXObjectHandler(OutputStream outputStream) throws IOException {
        this.objectStream = new ObjectOutputStream(outputStream);
    }

    @Override
    public void startDocument() {
        if (this.disabled) {
            return;
        }
        try {
            this.objectStream.writeObject(new SAXStartDocument());
            ++this.sAXEventsWritten;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disable();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.disabled) {
            return;
        }
        try {
            this.objectStream.writeObject(new SAXEndDocument());
            ++this.sAXEventsWritten;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disable();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.disabled) {
            return;
        }
        try {
            this.objectStream.writeObject(new SAXStartElement(uri, localName, qName, attributes));
            ++this.sAXEventsWritten;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disable();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.disabled) {
            return;
        }
        try {
            this.objectStream.writeObject(new SAXEndElement(uri, localName, qName));
            ++this.sAXEventsWritten;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disable();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.disabled) {
            return;
        }
        try {
            this.objectStream.writeObject(new SAXCharacters(ch, start, length));
            ++this.sAXEventsWritten;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.disable();
        }
    }

    public int getSAXEventsWritten() {
        return this.sAXEventsWritten;
    }

    public void markEndOfStream() throws IOException {
        if (this.disabled) {
            return;
        }
        this.objectStream.writeObject(new SAXEndOfStreamMarker());
    }

    public void disable() {
        this.disabled = true;
        try {
            this.objectStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

