package ar.com.sdd.edireader;

import ar.com.sdd.edireader.model.EdifactData;
import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.tokenizer.Tokenizer;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import java.io.FileReader;
import java.io.IOException;

public class EbfEdiScanner {

    private static Logger log = Logger.getLogger(EbfEdiScanner.class);
    private EdifactData edifactData;
    private EDIReader parser;
    private InputSource inputSource;

    public EbfEdiScanner(String input) {
        edifactData = new EdifactData();
        if(input != null) {
            try {
                inputSource =  new InputSource(new FileReader(input));
            }catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }

        }
    }

    public EdifactData getEdifactData() {
        return edifactData;
    }

  /* public static void main(String args[]) {
        CommandLine commandLine = new CommandLine(args);
        String inputFileName = commandLine.getPosition(0);
        if (inputFileName == null) throw new RuntimeException("Missing or invalid command line arguments");

        EbfEdiScanner scanner = new EbfEdiScanner(inputFileName);
//        EDIReader.setDebug(true);
        scanner.run();

       EdifactData edifactData = EdifactReader.edifactData;
       System.out.println(edifactData.toString());

    }*/
    public void run() {
        ContentHandler handler = new DefaultHandler();
        char[] preRead = null;

        try {
            while (true) {

                /*
                 * Como el archivo se puede leer parcialmente, mantenemos aca afuera el objeto edifactData
                 * y se lo vamos asignando al parser (y recuperandolo luego), en cada ciclo
                 *
                 * Si lo tuviese el parser, se eliminaria en cada ciclo
                 */
                parser = EDIReaderFactory.createEDIReader(inputSource, preRead);
                parser.setTempEdifactData(edifactData);

                if(parser == null) {
                    break;
                }
                parser.setContentHandler(handler);
                parser.parse(inputSource);

                //Recuperamos el data del parser
                edifactData = parser.getTempEdifactData();

                preRead = parser.getTokenizer().getBuffered();
            }
        }catch (IOException e) {
            throw new RuntimeException(e.getMessage());

        }catch (SAXException syntaxException) {
            log.error("Unrecoverable syntax exception: " + syntaxException.getClass().getCanonicalName() +
                    " - " + syntaxException.getMessage());

            Tokenizer ediTokenizer = parser.getTokenizer();
            log.error("Información de la EDIReader");
            char delimiter = ediTokenizer.getDelimiter();
            log.error("Field delimiter: " + representationOf(delimiter));
            char terminator = ediTokenizer.getTerminator();
            log.error("Segment terminator: " + representationOf(terminator));

            throw new RuntimeException(syntaxException.getMessage());
        }


    }

    private String representationOf(char c)
    {
        String result = "|" + c + "|";
        result += " (" + (int) c + ")";
        return result;
    }


}
