/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.plugin.LoopDescriptor;
import com.berryworks.edireader.plugin.PluginControllerImpl;
import com.berryworks.edireader.plugin.PluginPreparation;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.util.List;

public abstract class Plugin {
    public static final String ANY_CONTEXT = "*";
    public static final String INITIAL_CONTEXT = "/";
    public static final String CURRENT = ".";
    protected static int pluginsLoaded;
    protected LoopDescriptor[] loops;
    protected boolean debug;
    protected final String documentType;
    protected final String documentName;
    protected PluginPreparation optimizedForm;
    private boolean validating;

    public Plugin(String documentType, String documentName) {
        this.documentType = documentType;
        this.documentName = documentName;
        ++pluginsLoaded;
    }

    protected Plugin(String documentType, String documentName, boolean validating) {
        this(documentType, documentName);
        this.validating = validating;
    }

    public void init() {
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public LoopDescriptor query(String segment, String currentLoopStack, int currentLevel) {
        LoopDescriptor result = null;
        if (this.debug) {
            this.trace("plugin query for segment " + segment);
        }
        if (currentLoopStack == null) {
            currentLoopStack = ANY_CONTEXT;
        }
        if (this.loops == null) {
            return null;
        }
        if (this.optimizedForm == null) {
            throw new RuntimeException("Internal error: plugin not properly constructed");
        }
        List<LoopDescriptor> descriptorList = this.optimizedForm.getList(segment);
        if (descriptorList == null) {
            if (this.debug) {
                this.trace("No descriptors found");
            }
            return null;
        }
        if (this.debug) {
            this.trace("Number of descriptors found: " + descriptorList.size());
        }
        for (LoopDescriptor descriptor : descriptorList) {
            if (descriptor.getFirstSegment().equals(segment)) {
                int levelContext = descriptor.getLevelContext();
                if (this.debug) {
                    this.trace("checking level context " + levelContext);
                }
                if (levelContext > -1) {
                    if (levelContext != currentLevel) continue;
                    result = descriptor;
                    break;
                }
                String candidateContext = descriptor.getLoopContext();
                if (this.debug) {
                    this.trace("checking loop context " + candidateContext + " with current loop stack " + currentLoopStack);
                }
                if (ANY_CONTEXT.equals(candidateContext)) {
                    result = descriptor;
                    break;
                }
                if (candidateContext.startsWith(INITIAL_CONTEXT) && candidateContext.length() > 1 && currentLoopStack.startsWith(candidateContext)) {
                    if (this.debug) {
                        this.trace("startsWith satisfied");
                    }
                    result = descriptor;
                    break;
                }
                if (!currentLoopStack.endsWith(candidateContext)) continue;
                result = descriptor;
                break;
            }
            throw new RuntimeException("Internal error: optimized plugin structure invalid");
        }
        if (result != null && result.getName() == null) {
            result = null;
        }
        return result;
    }

    private void trace(String s) {
        EDIReader.trace(s);
    }

    public void debug(boolean d) {
        this.debug = d;
    }

    public static int getCount() {
        return pluginsLoaded;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Plugin ").append(this.getClass().getName());
        result.append("\n  ").append(this.getDocumentName()).append(" (").append(this.getDocumentType()).append(')');
        for (LoopDescriptor loop : this.loops) {
            result.append('\n').append(loop.toString());
        }
        return result.toString();
    }

    public void prepare() {
        this.optimizedForm = new PluginPreparation(this.loops);
    }

    public boolean isValidating() {
        return this.validating;
    }

    public PluginControllerImpl createController(String standard, Tokenizer tokenizer) {
        return new PluginControllerImpl(standard, tokenizer);
    }

    protected LoopDescriptor[] concatenate(LoopDescriptor[] descriptorsA, LoopDescriptor[] descriptorsB) {
        LoopDescriptor[] result = new LoopDescriptor[descriptorsA.length + descriptorsB.length];
        int loopsIndex = 0;
        for (LoopDescriptor d : descriptorsA) {
            result[loopsIndex++] = d;
        }
        for (LoopDescriptor d : descriptorsB) {
            result[loopsIndex++] = d;
        }
        return result;
    }
}

