/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.demo;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.error.EDISyntaxExceptionHandler;
import com.berryworks.edireader.error.RecoverableSyntaxException;
import com.berryworks.edireader.tokenizer.Tokenizer;
import com.berryworks.edireader.util.CommandLine;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EDIScanner {
    private InputSource inputSource;
    private PrintStream scannerOutput;
    private EDIReader parser;
    private int interchangeCount;

    public EDIScanner(String input, String output) {
        if (output != null) {
            try {
                this.scannerOutput = new PrintStream(new FileOutputStream(output));
                System.out.println("Output file " + output + " opened");
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.scannerOutput = System.out;
        }
        if (input != null) {
            try {
                this.inputSource = new InputSource(new FileReader(input));
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
        } else {
            this.inputSource = new InputSource(new InputStreamReader(System.in));
        }
    }

    public void run() {
        ScanningHandler handler = new ScanningHandler();
        char[] leftOver = null;
        try {
            while (true) {
                this.parser = EDIReaderFactory.createEDIReader(this.inputSource, leftOver);
                if (this.parser != null) {
                    this.parser.setContentHandler(handler);
                    this.parser.setSyntaxExceptionHandler(new SyntaxExceptionHandler());
                    this.parser.parse(this.inputSource);
                    leftOver = this.parser.getTokenizer().getBuffered();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        catch (SAXException syntaxException) {
            System.out.println();
            System.out.println("Unrecoverable syntax exception: " + syntaxException.getClass().getCanonicalName() + " - " + syntaxException.getMessage());
            Tokenizer ediTokenizer = this.parser.getTokenizer();
            System.out.println("Internal EDIReader diagnostic information: ");
            char delimiter = ediTokenizer.getDelimiter();
            System.out.println("Field delimiter: " + this.representationOf(delimiter));
            char terminator = ediTokenizer.getTerminator();
            System.out.println("Segment terminator: " + this.representationOf(terminator));
            throw new RuntimeException(syntaxException.getMessage());
        }
    }

    private String representationOf(char c) {
        String result = "|" + c + "|";
        result = result + " (" + c + ")";
        return result;
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine(args);
        String inputFileName = commandLine.getPosition(0);
        if (inputFileName == null) {
            EDIScanner.badArgs();
        }
        String outputFileName = commandLine.getOption("o");
        EDIScanner scanner = new EDIScanner(inputFileName, outputFileName);
        scanner.run();
    }

    private static void badArgs() {
        System.out.println("Usage: EDIScanner inputfile [-o outputfile]");
        throw new RuntimeException("Missing or invalid command line arguments");
    }

    public int interchangeCount() {
        return this.interchangeCount;
    }

    private class SyntaxExceptionHandler
    implements EDISyntaxExceptionHandler {
        private SyntaxExceptionHandler() {
        }

        @Override
        public boolean process(RecoverableSyntaxException syntaxException) {
            EDIScanner.this.scannerOutput.println();
            EDIScanner.this.scannerOutput.println("Recoverable syntax exception: " + syntaxException.getClass().getCanonicalName() + " - " + syntaxException.getMessage());
            return true;
        }
    }

    private class ScanningHandler
    extends DefaultHandler {
        private ScanningHandler() {
        }

        @Override
        public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
            String indent;
            if (localName.startsWith(EDIScanner.this.parser.getXMLTags().getInterchangeTag())) {
                EDIScanner.this.scannerOutput.println("+Interchange  (" + ++EDIScanner.this.interchangeCount + ")");
                indent = "   ";
            } else if (localName.startsWith(EDIScanner.this.parser.getXMLTags().getSenderTag())) {
                EDIScanner.this.scannerOutput.println("  +Sender");
                indent = "     ";
            } else if (localName.startsWith(EDIScanner.this.parser.getXMLTags().getReceiverTag())) {
                EDIScanner.this.scannerOutput.println("  +Recipient");
                indent = "     ";
            } else if (localName.startsWith(EDIScanner.this.parser.getXMLTags().getAddressTag())) {
                EDIScanner.this.scannerOutput.println("    +Address");
                indent = "       ";
            } else if (localName.startsWith(EDIScanner.this.parser.getXMLTags().getGroupTag())) {
                EDIScanner.this.scannerOutput.println("  +Group");
                indent = "     ";
            } else if (localName.startsWith(EDIScanner.this.parser.getXMLTags().getDocumentTag())) {
                EDIScanner.this.scannerOutput.println("    +Document");
                indent = "       ";
            } else {
                return;
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                EDIScanner.this.scannerOutput.println(indent + atts.getLocalName(i) + "=" + atts.getValue(i));
            }
        }
    }
}

