/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.formatter;

import com.berryworks.edireader.EDIReader;
import com.berryworks.edireader.EDIReaderFactory;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.formatter.FormatterHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.xml.sax.InputSource;

public class FormatterParser
implements Runnable {
    protected final Reader inputA;
    protected final Reader inputB;
    protected final PrintWriter output;
    protected String filename;

    public FormatterParser(Reader inputA, Reader inputB, PrintWriter output, String filename) {
        this(inputA, inputB, output);
        this.filename = filename;
    }

    public FormatterParser(Reader inputA, Reader inputB, PrintWriter output) {
        this.inputA = inputA;
        this.inputB = inputB;
        this.output = output;
    }

    @Override
    public void run() {
        InputSource inputSource = new InputSource(this.inputB);
        try {
            EDIReader ediReader = this.createEDIReader(inputSource);
            if (ediReader == null) {
                throw new RuntimeException("createEDIReader returned null");
            }
            this.log(ediReader);
            FormatterHandler handler = this.createFormatterHandler(ediReader, this.inputA, this.output);
            try {
                handler.preface();
                ediReader.setContentHandler(handler);
                ediReader.parse(inputSource);
                handler.addendum();
            }
            catch (Exception e) {
                handler.recover(e);
            }
        }
        catch (Exception e) {
            this.errorReport(e);
        }
        try {
            if (this.inputA != null) {
                this.inputA.close();
            }
            this.inputB.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected EDIReader createEDIReader(InputSource inputSource) throws EDISyntaxException, IOException {
        return EDIReaderFactory.createEDIReader(inputSource);
    }

    protected void log(EDIReader parser) {
    }

    protected void errorReport(Exception e) {
        this.output.println(e.getMessage());
    }

    protected FormatterHandler createFormatterHandler(EDIReader parser, Reader input, PrintWriter out) {
        return new FormatterHandler(parser, input, out);
    }
}

