/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.AnsiFAGenerator;
import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.ReplyGenerator;
import com.berryworks.edireader.StandardReader;
import com.berryworks.edireader.error.GroupControlNumberException;
import com.berryworks.edireader.error.GroupCountException;
import com.berryworks.edireader.error.InterchangeControlNumberException;
import com.berryworks.edireader.error.MissingMandatoryElementException;
import com.berryworks.edireader.error.SegmentCountException;
import com.berryworks.edireader.error.TransactionControlNumberException;
import com.berryworks.edireader.error.TransactionCountException;
import com.berryworks.edireader.tokenizer.Token;
import com.berryworks.edireader.util.ContentHandlerBase64Encoder;
import java.io.IOException;
import java.util.List;
import org.xml.sax.SAXException;

public class AnsiReader
extends StandardReader {
    protected String groupFunctionCode;
    protected String groupSender;
    protected String groupReceiver;
    protected String groupVersion;
    protected String groupDate;

    @Override
    protected Token recognizeBeginning() throws IOException, EDISyntaxException {
        Token t = this.getTokenizer().nextToken();
        if (t.getType() != Token.TokenType.SEGMENT_START || !t.valueEquals("ISA")) {
            throw new EDISyntaxException("ANSI X.12 interchange must begin with ISA");
        }
        return t;
    }

    @Override
    protected Token parseInterchange(Token token) throws SAXException, IOException {
        String s;
        String sType;
        this.setGroupCount(0);
        if (debug) {
            AnsiReader.trace("entering parseInterchange");
        }
        this.getInterchangeAttributes().clear();
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getStandard(), "ANSI X.12");
        String authQual = this.getFixedLengthISAField(2);
        String authInfo = this.getFixedLengthISAField(10);
        String securityQual = this.getFixedLengthISAField(2);
        String securityInfo = this.getFixedLengthISAField(10);
        if (authInfo.charAt(0) != ' ') {
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getAuthorizationQual(), authQual);
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getAuthorization(), authInfo);
        }
        if (securityInfo.charAt(0) != ' ') {
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSecurityQual(), securityQual);
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getSecurity(), securityInfo);
        }
        String fromQual = this.getFixedLengthISAField(2);
        this.process("ISA05", fromQual);
        String fromId = this.getFixedLengthISAField(15, false);
        this.process("ISA06", fromId);
        String toQual = this.getFixedLengthISAField(2);
        this.process("ISA07", toQual);
        String toId = this.getFixedLengthISAField(15, false);
        this.process("ISA08", fromId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getDate(), this.getTokenizer().nextSimpleValue());
        String controlTime = this.getTokenizer().nextSimpleValue();
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getTime(), controlTime);
        int separator = this.getTokenizer().getRepetitionSeparator();
        if (separator == -1) {
            String standardsId = this.getFixedLengthISAField(1);
            this.getInterchangeAttributes().addCDATA(this.getXMLTags().getStandardsId(), standardsId);
        } else {
            this.getTokenizer().setRepetitionSeparator(-1);
            this.getFixedLengthISAField(1);
            this.getTokenizer().setRepetitionSeparator(separator);
        }
        String versionId = this.getFixedLengthISAField(5);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getVersion(), versionId);
        this.setInterchangeControlNumber(this.getFixedLengthISAField(9));
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getControl(), this.getInterchangeControlNumber());
        while (this.getTokenizer().nextToken().getType() != Token.TokenType.SEGMENT_END) {
            if (this.getTokenizer().getElementInSegmentCount() <= 30) continue;
            throw new EDISyntaxException("Too many fields for an ISA (Segment terminator problem?)", this.getTokenizer());
        }
        this.startElement(this.getXMLTags().getInterchangeTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().clear();
        this.startElement(this.getXMLTags().getSenderTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getIdAttribute(), fromId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getQualifierAttribute(), fromQual);
        this.startElement(this.getXMLTags().getAddressTag(), this.getInterchangeAttributes());
        this.endElement(this.getXMLTags().getAddressTag());
        this.endElement(this.getXMLTags().getSenderTag());
        this.getInterchangeAttributes().clear();
        this.startElement(this.getXMLTags().getReceiverTag(), this.getInterchangeAttributes());
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getIdAttribute(), toId);
        this.getInterchangeAttributes().addCDATA(this.getXMLTags().getQualifierAttribute(), toQual);
        this.startElement(this.getXMLTags().getAddressTag(), this.getInterchangeAttributes());
        this.endElement(this.getXMLTags().getAddressTag());
        this.endElement(this.getXMLTags().getReceiverTag());
        while (true) {
            if ((token = this.getTokenizer().nextToken()).getType() != Token.TokenType.SEGMENT_START) {
                throw new EDISyntaxException("Invalid beginning of segment", this.getTokenizer().getSegmentCount());
            }
            sType = token.getValue();
            if ("GS".equals(sType)) {
                this.setGroupCount(1 + this.getGroupCount());
                this.parseFunctionalGroup(token);
                continue;
            }
            if (!"TA1".equals(sType)) break;
            this.parseTA1(token);
        }
        if (!"IEA".equals(sType)) {
            throw new EDISyntaxException("Unexpected segment type in this context", "IEA or GS", sType, this.getTokenizer());
        }
        int n = this.getTokenizer().nextIntValue();
        if (this.getGroupCount() != n) {
            GroupCountException countException = new GroupCountException("Functional group count error in IEA segment", this.getGroupCount(), n, this.getTokenizer());
            this.setSyntaxException(countException);
            if (!this.recover(countException)) {
                throw countException;
            }
        }
        if (!(s = this.getTokenizer().nextSimpleValue()).equals(this.getInterchangeControlNumber())) {
            InterchangeControlNumberException interchangeControlNumberException = new InterchangeControlNumberException("Control number error in IEA segment", this.getInterchangeControlNumber(), s, this.getTokenizer());
            this.setSyntaxException(interchangeControlNumberException);
            if (!this.recover(interchangeControlNumberException)) {
                throw interchangeControlNumberException;
            }
        }
        this.getAckGenerator().generateAcknowledgementWrapup();
        this.endElement(this.getXMLTags().getInterchangeTag());
        return this.getTokenizer().skipSegment();
    }

    protected void parseTA1(Token token) throws SAXException, IOException {
        EDIAttributes attributes = new EDIAttributes();
        String acknowledgedControlNumber = this.getTokenizer().nextSimpleValue();
        attributes.addCDATA(this.getXMLTags().getControl(), acknowledgedControlNumber);
        String acknowledgedDate = this.getTokenizer().nextSimpleValue();
        attributes.addCDATA(this.getXMLTags().getDate(), acknowledgedDate);
        String acknowledgedTime = this.getTokenizer().nextSimpleValue();
        attributes.addCDATA(this.getXMLTags().getTime(), acknowledgedTime);
        String code = this.getTokenizer().nextSimpleValue();
        attributes.addCDATA(this.getXMLTags().getAcknowledgementCode(), code);
        String note = this.getTokenizer().nextSimpleValue(false, true);
        if (note != null) {
            if (note.length() > 0) {
                attributes.addCDATA(this.getXMLTags().getNotCode(), note);
            }
            this.getTokenizer().skipSegment();
        }
        this.startElement(this.getXMLTags().getAcknowledgementTag(), attributes);
        this.endElement(this.getXMLTags().getAcknowledgementTag());
    }

    protected String getFixedLengthISAField(int expectedLength) throws IOException, SAXException {
        return this.getFixedLengthISAField(expectedLength, true);
    }

    protected String getFixedLengthISAField(int expectedLength, boolean enforce) throws SAXException, IOException {
        String field = this.getTokenizer().nextSimpleValue();
        if (field.length() != expectedLength) {
            if (enforce) {
                throw new EDISyntaxException("Incorrect length of fixed-length ISA field", expectedLength, field.length(), this.getTokenizer());
            }
            field = this.fixLength(field, expectedLength);
        }
        return field;
    }

    private String fixLength(String field, int expectedLength) {
        String result;
        if (field.length() < expectedLength) {
            StringBuilder sb = new StringBuilder(field);
            for (int i = field.length(); i < expectedLength; ++i) {
                sb.append(' ');
            }
            result = sb.toString();
        } else {
            result = field.substring(0, expectedLength);
        }
        return result;
    }

    protected Token parseFunctionalGroup(Token token) throws SAXException, IOException {
        String s;
        String sType;
        int docCount = 0;
        this.getGroupAttributes().clear();
        this.groupFunctionCode = this.getTokenizer().nextSimpleValue();
        this.getGroupAttributes().addCDATA(this.getXMLTags().getGroupType(), this.groupFunctionCode);
        this.groupSender = this.getTokenizer().nextSimpleValue(false);
        this.process("GS02", this.groupSender);
        this.groupReceiver = this.getTokenizer().nextSimpleValue(false);
        this.process("GS03", this.groupReceiver);
        this.groupDate = this.getTokenizer().nextSimpleValue();
        this.getGroupAttributes().addCDATA(this.getXMLTags().getApplSender(), this.groupSender);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getApplReceiver(), this.groupReceiver);
        this.getGroupAttributes().addCDATA(this.getXMLTags().getDate(), this.groupDate);
        String value = "";
        try {
            value = this.getTokenizer().nextSimpleValue();
        }
        catch (EDISyntaxException e) {
            if (e.getMessage().startsWith("Mandatory")) {
                MissingMandatoryElementException missingMandatoryElementException = new MissingMandatoryElementException("Mandatory element missing", "at least one non-space character", "(empty)", this.getTokenizer());
                this.setSyntaxException(missingMandatoryElementException);
                if (!this.recover(missingMandatoryElementException)) {
                    throw missingMandatoryElementException;
                }
            }
            throw e;
        }
        this.getGroupAttributes().addCDATA(this.getXMLTags().getTime(), value);
        this.setGroupControlNumber(this.getTokenizer().nextSimpleValue());
        this.getGroupAttributes().addCDATA(this.getXMLTags().getControl(), this.getGroupControlNumber());
        this.getGroupAttributes().addCDATA(this.getXMLTags().getStandardCode(), this.getTokenizer().nextSimpleValue());
        Token t = this.getTokenizer().nextToken();
        if (t.getType() == Token.TokenType.SEGMENT_END) {
            this.groupVersion = "";
        } else {
            this.groupVersion = t.getValue();
            this.getGroupAttributes().addCDATA(this.getXMLTags().getStandardVersion(), this.groupVersion);
            this.getTokenizer().skipSegment();
        }
        this.startElement(this.getXMLTags().getGroupTag(), this.getGroupAttributes());
        this.getAckGenerator().generateAcknowledgmentHeader(this.getFirstSegment(), this.groupSender, this.groupReceiver, this.groupDate.length(), this.groupVersion, this.groupFunctionCode, this.getGroupControlNumber());
        while (true) {
            if ((token = this.getTokenizer().nextToken()).getType() != Token.TokenType.SEGMENT_START) {
                throw new EDISyntaxException("Invalid beginning of segment", this.getTokenizer().getSegmentCount());
            }
            sType = token.getValue();
            if (!sType.equals("ST")) break;
            ++docCount;
            this.parseDocument(token);
        }
        if (!sType.equals("GE")) {
            throw new EDISyntaxException("Unexpected segment type in this context", "GE or ST", sType, this.getTokenizer());
        }
        int n = this.getTokenizer().nextIntValue();
        if (docCount != n) {
            TransactionCountException countException = new TransactionCountException("Transaction count error in GE segment", docCount, n, this.getTokenizer());
            this.setSyntaxException(countException);
            if (!this.recover(countException)) {
                throw countException;
            }
        }
        if (!(s = this.getTokenizer().nextSimpleValue()).equals(this.getGroupControlNumber())) {
            GroupControlNumberException groupControlNumberException = new GroupControlNumberException("Control number error in GE segment", this.getGroupControlNumber(), s, this.getTokenizer());
            this.setSyntaxException(groupControlNumberException);
            if (!this.recover(groupControlNumberException)) {
                throw groupControlNumberException;
            }
        }
        this.endElement(this.getXMLTags().getGroupTag());
        this.getAckGenerator().generateGroupAcknowledgmentTrailer(docCount);
        return this.getTokenizer().skipSegment();
    }

    protected void process(String ediElement, String value) throws SAXException {
    }

    protected Token parseDocument(Token token) throws SAXException, IOException {
        String s;
        String segmentType;
        String code;
        PluginController pluginController;
        int segCount = 2;
        if (debug) {
            AnsiReader.trace("entering parseDocument");
        }
        if (this.getTransactionCallback() != null) {
            this.getTransactionCallback().startTransaction(token.getValue());
        }
        this.getDocumentAttributes().clear();
        String documentType = this.getTokenizer().nextSimpleValue();
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getDocumentType(), documentType);
        PluginController.setDebug(debug);
        String version = this.groupVersion;
        if (version.length() > 6) {
            version = version.substring(0, 6);
        }
        if ((pluginController = PluginController.create("ANSI", documentType, code = this.getGroupAttributes().getValue(this.getXMLTags().getStandardCode()), version, this.getTokenizer())).isEnabled()) {
            this.getDocumentAttributes().addCDATA(this.getXMLTags().getName(), pluginController.getDocumentName());
        }
        String control = this.getTokenizer().nextSimpleValue();
        this.getDocumentAttributes().addCDATA(this.getXMLTags().getControl(), control);
        this.getTokenizer().skipSegment();
        this.startElement(this.getXMLTags().getDocumentTag(), this.getDocumentAttributes());
        while (!(segmentType = this.getTokenizer().nextSegment()).equals("SE")) {
            if (debug) {
                AnsiReader.trace("parsing segment " + segmentType + " within the " + documentType + " document");
            }
            ++segCount;
            if ("BIN".equals(segmentType)) {
                this.parseBINSequence();
                continue;
            }
            this.parseSegment(pluginController, segmentType);
        }
        int toClose = pluginController.getNestingLevel();
        if (debug) {
            AnsiReader.trace("closing all " + toClose + " loops");
        }
        while (toClose > 0) {
            this.endElement(this.getXMLTags().getLoopTag());
            --toClose;
        }
        int n = this.getTokenizer().nextIntValue();
        if (segCount != n) {
            SegmentCountException countException = new SegmentCountException("Segment count error in SE segment", segCount, n, this.getTokenizer());
            this.setSyntaxException(countException);
            if (!this.recover(countException)) {
                throw countException;
            }
        }
        if (!(s = this.getTokenizer().nextSimpleValue()).equals(control)) {
            TransactionControlNumberException transactionControlNumberException = new TransactionControlNumberException("Control number error in SE segment", control, s, this.getTokenizer());
            this.setSyntaxException(transactionControlNumberException);
            if (!this.recover(transactionControlNumberException)) {
                throw transactionControlNumberException;
            }
        }
        this.getAckGenerator().generateTransactionAcknowledgment(documentType, control);
        this.endElement(this.getXMLTags().getDocumentTag());
        Token t = this.getTokenizer().skipSegment();
        if (this.getTransactionCallback() != null) {
            this.getTransactionCallback().endTransaction();
        }
        return t;
    }

    protected void parseBINSequence() throws SAXException, IOException {
        int length;
        if (debug) {
            AnsiReader.trace("BIN detected, introducing an octet sequence object");
        }
        String lengthField = "";
        try {
            lengthField = this.parseStringFromNextElement();
            length = Integer.parseInt(lengthField);
        }
        catch (EDISyntaxException e) {
            throw new EDISyntaxException("UNO segment missing mandatory length field", this.getTokenizer());
        }
        catch (NumberFormatException e) {
            throw new EDISyntaxException("BIN object length must be numeric instead of " + lengthField, this.getTokenizer());
        }
        char[] dataObject = this.getTokenizer().getChars(length);
        if (debug) {
            AnsiReader.trace("Data object of length " + dataObject.length);
        }
        Token token = this.getTokenizer().nextToken();
        if (debug) {
            AnsiReader.trace("Token after BIN: " + token);
        }
        this.getDocumentAttributes().clear();
        this.startElement(this.getXMLTags().getPackageTag(), this.getDocumentAttributes());
        new ContentHandlerBase64Encoder().encode(dataObject, this.getContentHandler());
        this.endElement(this.getXMLTags().getPackageTag());
    }

    private String parseStringFromNextElement() throws IOException, EDISyntaxException {
        String obj;
        List<String> v = this.getTokenizer().nextCompositeElement();
        if (v != null && v.size() > 0 && (obj = v.get(0)) != null) {
            return obj;
        }
        throw new EDISyntaxException("Mandatory element missing", this.getTokenizer());
    }

    @Override
    public void preview() throws EDISyntaxException, IOException {
        if (debug) {
            AnsiReader.trace("previewing ANSI interchange for syntax details");
        }
        if (this.isPreviewed()) {
            throw new EDISyntaxException("End-of-file hit multiple times (internal error)");
        }
        this.setRelease(-1);
        char[] buf = this.getTokenizer().lookahead(128);
        if (buf == null || buf.length < 128) {
            throw new EDISyntaxException("Incomplete ANSI X.12 interchange");
        }
        if (buf[0] != 'I' || buf[1] != 'S' || buf[2] != 'A') {
            throw new EDISyntaxException("ANSI X.12 interchange must begin with ISA");
        }
        char c = buf[3];
        this.setDelimiter(c);
        int indexOf16thFieldSeparator = AnsiReader.indexOf(c, buf, 16);
        if (indexOf16thFieldSeparator < 0) {
            throw new EDISyntaxException("ISA segment requires 16 instances of the field delimiter");
        }
        c = buf[indexOf16thFieldSeparator + 1];
        if (this.isAcceptable(c)) {
            this.setSubDelimiter(c);
        }
        if (!this.isAcceptable(c = buf[indexOf16thFieldSeparator + 2])) {
            throw new EDISyntaxException("Invalid segment terminator");
        }
        this.setTerminator(c);
        this.setTerminatorSuffix(AnsiReader.findTerminatorSuffix(buf, indexOf16thFieldSeparator + 3, 128));
        int indexOf11thFieldSeparator = AnsiReader.indexOf(this.getDelimiter(), buf, 11);
        char repetitionChar = buf[indexOf11thFieldSeparator + 1];
        if (Character.isLetterOrDigit(repetitionChar) || repetitionChar == this.getTerminator() || repetitionChar == this.getDelimiter() || Character.isWhitespace(repetitionChar)) {
            this.setRepetitionSeparator('\u0000');
        } else {
            this.setRepetitionSeparator(repetitionChar);
        }
        this.setFirstSegment(new String(buf, 0, indexOf16thFieldSeparator + 3));
        this.setPreviewed(true);
    }

    private static int indexOf(char c, char[] buf, int n) {
        int result = -1;
        int count = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != c || ++count != n) continue;
            result = i;
            break;
        }
        return result;
    }

    protected boolean isAcceptable(char c) {
        return this.getDelimiter() != c;
    }

    protected static String findTerminatorSuffix(char[] buf, int i, int j) {
        StringBuilder result = new StringBuilder();
        for (int n = i; n < j && !Character.isLetter(buf[n]); ++n) {
            result.append(buf[n]);
        }
        return result.toString();
    }

    @Override
    public ReplyGenerator getAckGenerator() {
        if (super.getAckGenerator() == null) {
            if (debug) {
                AnsiReader.trace("constructing AnsiFAGenerator");
            }
            this.setAckGenerator(new AnsiFAGenerator(this, this.getAckStream()));
        }
        return super.getAckGenerator();
    }
}

