/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.tokenizer.Tokenizer;
import java.io.IOException;
import org.xml.sax.SAXException;

public class EDISyntaxException
extends SAXException {
    private int errorSegmentNumber;
    private int errorElementNumber;

    public EDISyntaxException(String desc) {
        super(desc);
    }

    public EDISyntaxException(String desc, int seg) {
        super(desc + " at segment " + seg);
        this.errorSegmentNumber = seg;
    }

    public EDISyntaxException(String desc, Tokenizer tokenizer) {
        super(desc + " at segment " + tokenizer.getSegmentCount() + ", field " + tokenizer.getElementInSegmentCount());
        this.errorSegmentNumber = tokenizer.getSegmentCount();
        this.errorElementNumber = tokenizer.getElementInSegmentCount();
    }

    public EDISyntaxException(String desc, String expected, String actual, Tokenizer tokenizer) {
        this(desc + ". Expected " + expected + " instead of " + actual, tokenizer);
    }

    public EDISyntaxException(String desc, int expected, int actual, Tokenizer tokenizer) {
        this(desc + ". Expected " + expected + " instead of " + actual, tokenizer);
    }

    public EDISyntaxException(String desc, IOException e) {
        this(desc);
    }

    public int getErrorElementNumber() {
        return this.errorElementNumber;
    }

    public int getErrorSegmentNumber() {
        return this.errorSegmentNumber;
    }
}

