/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EDIAbstractReader;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.Plugin;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PluginController {
    protected static boolean debug;

    public static PluginController create(String standard, String docType, Tokenizer tokenizer) {
        return PluginController.create(standard, docType, null, null, tokenizer);
    }

    public static PluginController create(String standard, String docType, String docVersion, String docRelease, Tokenizer tokenizer) {
        try {
            Class<?> controllerClass = Class.forName("com.berryworks.edireader.plugin.PluginControllerImpl");
            Method createMethod = controllerClass.getDeclaredMethod("create", String.class, String.class, String.class, String.class, Tokenizer.class);
            return (PluginController)createMethod.invoke(null, standard, docType, docVersion, docRelease, tokenizer);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new PluginController();
    }

    public boolean transition(String segmentName) throws EDISyntaxException {
        return false;
    }

    public String getLoopEntered() {
        return null;
    }

    public int closedCount() {
        return 0;
    }

    public int getNestingLevel() {
        return 0;
    }

    public boolean isEnabled() {
        return false;
    }

    public String getDocumentName() {
        return null;
    }

    public Plugin getPlugin() {
        return null;
    }

    protected static void trace(String text) {
        EDIAbstractReader.trace(text);
    }

    public boolean isResumed() {
        return false;
    }

    public String lastPluginLoaded() {
        return null;
    }

    public static void setDebug(boolean d) {
        if (d) {
            if (debug) {
                PluginController.trace("PluginController: debug already on");
            } else {
                PluginController.trace("PluginController: debug turn on");
                debug = true;
            }
        } else if (debug) {
            PluginController.trace("PluginController: debug turn off");
            debug = false;
        }
    }
}

