/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util.sax;

import com.berryworks.edireader.util.sax.SAXEndDocument;
import com.berryworks.edireader.util.sax.SAXEndOfStreamMarker;
import com.berryworks.edireader.util.sax.SAXObject;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXObjectReader
implements XMLReader {
    private ContentHandler contentHandler;
    private ObjectInputStream inputStream;

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.inputStream == null) {
            System.err.println(this.getClass().getName() + " parsing first time on input stream");
            this.inputStream = new ObjectInputStream(input.getByteStream());
        } else {
            System.err.println(this.getClass().getName() + " parsing again on the same input stream");
        }
        try {
            block6: {
                SAXObject saxObject;
                do {
                    Object o;
                    if ((o = this.inputStream.readObject()) == null) {
                        System.err.println("SAXObjectReader got null from readObject(), parse throwing EOFException");
                        throw new EOFException();
                    }
                    saxObject = (SAXObject)o;
                    saxObject.saxCall(this.contentHandler);
                    if (saxObject instanceof SAXEndDocument) break block6;
                } while (!(saxObject instanceof SAXEndOfStreamMarker));
                throw new EOFException();
            }
            System.err.println("SAXObjectReader noted the end document, parse returning");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    public static void main(String[] arg) {
        SAXObjectReader reader = new SAXObjectReader();
        reader.setContentHandler(new DefaultHandler());
        try {
            reader.parse(new InputSource(new FileInputStream("queue.ser")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

