/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader;

import com.berryworks.edireader.EDIAttributes;
import com.berryworks.edireader.EdifactCONTRLGenerator;
import com.berryworks.edireader.EdifactReader;
import com.berryworks.edireader.ReplyGenerator;
import java.io.IOException;
import org.xml.sax.SAXException;

public class EdifactReaderWithCONTRL
extends EdifactReader {
    @Override
    protected void startInterchange(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getInterchangeTag(), attributes);
        this.getEdifactCONTRLGenerator().generateAcknowledgmentHeader(attributes);
    }

    @Override
    protected void endInterchange() throws SAXException {
        this.endElement(this.getXMLTags().getInterchangeTag());
        try {
            this.getAckGenerator().generateAcknowledgementWrapup();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    protected void startSenderAddress(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getAddressTag(), attributes);
        this.getEdifactCONTRLGenerator().setSender(attributes);
    }

    @Override
    protected void startReceiverAddress(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getAddressTag(), attributes);
        this.getEdifactCONTRLGenerator().setReceiver(attributes);
    }

    @Override
    protected void startMessage(EDIAttributes attributes) throws SAXException {
        this.startElement(this.getXMLTags().getDocumentTag(), attributes);
        try {
            this.getEdifactCONTRLGenerator().generateTransactionAcknowledgment(attributes);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected EdifactCONTRLGenerator getEdifactCONTRLGenerator() {
        return (EdifactCONTRLGenerator)this.getAckGenerator();
    }

    @Override
    public ReplyGenerator getAckGenerator() {
        if (super.getAckGenerator() == null) {
            this.setAckGenerator(new EdifactCONTRLGenerator(this, this.getAckStream()));
        }
        return super.getAckGenerator();
    }
}

