/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.plugin;

import com.berryworks.edireader.EDIAbstractReader;
import com.berryworks.edireader.EDISyntaxException;
import com.berryworks.edireader.Plugin;
import com.berryworks.edireader.PluginController;
import com.berryworks.edireader.plugin.LoopContext;
import com.berryworks.edireader.plugin.LoopDescriptor;
import com.berryworks.edireader.plugin.LoopStack;
import com.berryworks.edireader.tokenizer.Tokenizer;
import java.util.HashMap;
import java.util.Map;

public class PluginControllerImpl
extends PluginController {
    public static final String DEFAULT_EDIREADER_PLUGIN_PACKAGE = "com.berryworks.edireader.plugin";
    protected static final Map<String, Plugin> pluginCache = new HashMap<String, Plugin>();
    protected static String lastPluginLoaded = null;
    protected boolean enabled;
    protected final String standard;
    protected String documentType;
    protected Plugin plugin;
    protected LoopStack loopStack;
    protected final Tokenizer tokenizer;
    protected String currentLoopName = "/";
    protected LoopDescriptor loopDescriptor = new LoopDescriptor(this.currentLoopName, "", 0, "/");
    protected int numberOfLoopsClosed;

    public PluginControllerImpl(String standard, Tokenizer tokenizer) {
        this.standard = standard;
        this.tokenizer = tokenizer;
    }

    public static PluginControllerImpl create(String standard, String docType, Tokenizer tokenizer) {
        return PluginControllerImpl.create(standard, docType, null, null, tokenizer);
    }

    public static PluginControllerImpl create(String standard, String docType, String docVersion, String docRelease, Tokenizer tokenizer) {
        PluginControllerImpl result;
        Plugin plugin = PluginControllerImpl.loadPlugin(standard, docType, docVersion, docRelease);
        if (plugin == null) {
            result = new PluginControllerImpl(standard, tokenizer);
            result.enabled = false;
        } else {
            plugin.init();
            result = plugin.createController(standard, tokenizer);
            result.enabled = true;
        }
        result.documentType = docType;
        result.loopStack = new LoopStack();
        result.plugin = plugin;
        return result;
    }

    @Override
    public boolean transition(String segmentName) throws EDISyntaxException {
        if (!this.enabled) {
            return false;
        }
        if (debug) {
            PluginControllerImpl.trace("considering segment " + segmentName + " while in loop " + this.loopDescriptor.getName() + " with stack " + this.loopStack.toString());
        }
        boolean result = false;
        LoopDescriptor newDescriptor = this.plugin.query(segmentName, this.loopStack.toString(), this.loopDescriptor.getNestingLevel());
        if (debug) {
            PluginControllerImpl.trace("considering segment " + segmentName + " using descriptor " + newDescriptor);
        }
        if (!this.validateDescriptor(newDescriptor, segmentName, this.tokenizer)) {
            return false;
        }
        String newLoopName = newDescriptor.getName();
        if (".".equals(newLoopName) && newDescriptor.getNestingLevel() == this.loopDescriptor.getNestingLevel()) {
            if (debug) {
                PluginControllerImpl.trace("resuming current loop without transition");
            }
        } else {
            if (debug) {
                PluginControllerImpl.trace("transitioning to level " + newDescriptor.getNestingLevel());
            }
            result = true;
            this.numberOfLoopsClosed = this.loopDescriptor.getNestingLevel() - newDescriptor.getNestingLevel();
            boolean resumeLoop = true;
            if (newLoopName.startsWith("/")) {
                this.currentLoopName = newLoopName;
            } else if (newLoopName.startsWith(".")) {
                this.currentLoopName = newDescriptor.getNestingLevel() == 0 ? "/" : ".";
            } else {
                ++this.numberOfLoopsClosed;
                this.currentLoopName = newLoopName;
                resumeLoop = false;
            }
            if (debug) {
                PluginControllerImpl.trace("closing " + this.numberOfLoopsClosed + " loops");
            }
            if (this.numberOfLoopsClosed < 0 || this.numberOfLoopsClosed > this.loopDescriptor.getNestingLevel()) {
                throw new EDISyntaxException("Improper sequencing noted with segment " + segmentName, this.tokenizer);
            }
            if (this.numberOfLoopsClosed > 0) {
                for (int i = 0; i < this.numberOfLoopsClosed; ++i) {
                    LoopContext completedLoop = this.loopStack.pop();
                    this.validateCompletedLoop(completedLoop);
                    if (!debug) continue;
                    PluginControllerImpl.trace("popped " + completedLoop + " off the stack");
                }
            }
            this.loopDescriptor = newDescriptor;
            if (resumeLoop) {
                if (debug) {
                    PluginControllerImpl.trace("resuming loop at level " + this.loopDescriptor.getNestingLevel() + " with name " + this.loopDescriptor.getName());
                }
                if (this.loopDescriptor.getNestingLevel() == 0 && this.loopDescriptor.getName().length() > 1 && this.loopDescriptor.getName().startsWith("/")) {
                    if (debug) {
                        PluginControllerImpl.trace("special legacy case: " + this.loopDescriptor);
                    }
                    this.loopStack.setBottom(new LoopContext(this.loopDescriptor.getName().substring(1)));
                }
            } else {
                this.loopStack.push(this.createLoopContext(this.loopDescriptor.getName(), this.plugin, this.loopStack.toString()));
                if (debug) {
                    PluginControllerImpl.trace("pushed " + this.loopDescriptor.getName() + " onto the stack");
                }
            }
        }
        return this.validateSegment(newDescriptor, this.loopStack, this.tokenizer) && result;
    }

    protected LoopContext createLoopContext(String name, Plugin plugin, String s) {
        return new LoopContext(name);
    }

    protected boolean validateDescriptor(LoopDescriptor descriptor, String segmentName, Tokenizer tokenizer) throws EDISyntaxException {
        return descriptor != null;
    }

    protected void validateCompletedLoop(LoopContext completedLoop) throws EDISyntaxException {
    }

    protected boolean validateSegment(LoopDescriptor descriptor, LoopStack loopStack, Tokenizer tokenizer) throws EDISyntaxException {
        return true;
    }

    protected LoopStack getLoopStack() {
        return this.loopStack;
    }

    @Override
    public String getLoopEntered() {
        return this.currentLoopName;
    }

    @Override
    public int closedCount() {
        return this.numberOfLoopsClosed;
    }

    @Override
    public int getNestingLevel() {
        return this.loopDescriptor.getNestingLevel();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getDocumentName() {
        return this.enabled ? this.plugin.getDocumentName() : null;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    protected static void trace(String text) {
        EDIAbstractReader.trace(text);
    }

    @Override
    public boolean isResumed() {
        String s = this.getLoopEntered();
        return s.startsWith("/") || ".".equals(s);
    }

    protected static Plugin loadPlugin(String standard, String docType, String docVersion, String docRelease) {
        Plugin result = null;
        String key = standard + "_" + docType + "_" + docVersion + "_" + docRelease;
        if (pluginCache.containsKey(key)) {
            if (debug) {
                PluginControllerImpl.trace("plugin for " + key + " found in cache");
            }
            lastPluginLoaded = key;
            result = pluginCache.get(key);
        } else {
            String suffix = System.getProperty("EDIREADER_PLUGIN_SUFFIX");
            if (docVersion != null && docVersion.length() > 0 && docRelease != null && docRelease.length() > 0) {
                if (suffix != null && suffix.length() > 0) {
                    result = PluginControllerImpl.lookForSpecificPlugin(standard, docVersion + "_" + docRelease + "." + standard + "_" + docType + "_" + suffix);
                }
                if (result == null) {
                    result = PluginControllerImpl.lookForSpecificPlugin(standard, docVersion + "_" + docRelease + "." + standard + "_" + docType);
                }
                if (suffix != null && suffix.length() > 0) {
                    result = PluginControllerImpl.lookForSpecificPlugin(standard, docType + "_" + docVersion + "_" + docRelease + "_" + suffix);
                }
                if (result == null) {
                    result = PluginControllerImpl.lookForSpecificPlugin(standard, docType + "_" + docVersion + "_" + docRelease);
                }
            }
            if (result == null && suffix != null && suffix.length() > 0) {
                result = PluginControllerImpl.lookForSpecificPlugin(standard, docType + "_" + suffix);
            }
            if (result == null) {
                result = PluginControllerImpl.lookForSpecificPlugin(standard, docType);
            }
            pluginCache.put(key, result);
        }
        return result;
    }

    @Override
    public String lastPluginLoaded() {
        return lastPluginLoaded;
    }

    protected static Plugin lookForSpecificPlugin(String standard, String docType) {
        Plugin pluginFound;
        block7: {
            pluginFound = null;
            try {
                pluginFound = PluginControllerImpl.getInstance(standard, docType);
                if (debug) {
                    pluginFound.debug(true);
                    PluginControllerImpl.trace("plugin found for document type " + docType + ": " + pluginFound.getDocumentName());
                }
            }
            catch (ClassNotFoundException e) {
                if (debug) {
                    PluginControllerImpl.trace("plugin for " + docType + " not available");
                }
            }
            catch (InstantiationException e) {
                if (debug) {
                    PluginControllerImpl.trace("plugin for " + docType + " could not be instantiated");
                }
            }
            catch (IllegalAccessException e) {
                if (!debug) break block7;
                PluginControllerImpl.trace("plugin for " + docType + " caused IllegalAccessException" + e);
            }
        }
        return pluginFound;
    }

    protected static Plugin getInstance(String standard, String docType) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String pluginName = PluginControllerImpl.pluginPackage() + "." + standard + "_" + docType;
        if (debug) {
            PluginControllerImpl.trace("attempting to load a plugin named " + pluginName);
        }
        Class<?> pluginClass = Class.forName(pluginName);
        if (debug) {
            PluginControllerImpl.trace("plugin loaded");
        }
        Plugin instance = (Plugin)pluginClass.newInstance();
        instance.prepare();
        lastPluginLoaded = pluginName;
        return instance;
    }

    protected static String pluginPackage() {
        String packageName = System.getProperty("EDIREADER_PLUGIN_PACKAGE");
        if (packageName == null) {
            packageName = DEFAULT_EDIREADER_PLUGIN_PACKAGE;
            if (debug) {
                PluginControllerImpl.trace("Plugin package defaults to " + packageName);
            }
        } else if (debug) {
            PluginControllerImpl.trace("Plugin package set by property to " + packageName);
        }
        return packageName;
    }
}

