/*
 * Decompiled with CFR 0.152.
 */
package com.berryworks.edireader.util;

public class XmlFormatter {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String INDENT = "    ";
    private static final int INDENT_LENGTH = 4;

    public String format(String xmlText) {
        int i;
        String indent = "";
        int startLookingAtIndex = 0;
        while ((i = xmlText.indexOf("><", startLookingAtIndex)) >= 0) {
            char peekAhead = xmlText.charAt(i + 2);
            int delta = this.changeIndent(xmlText, i, peekAhead);
            if (delta < 0) {
                switch (indent.length()) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        indent = "";
                        break;
                    }
                    default: {
                        indent = indent.substring(INDENT.length());
                        break;
                    }
                }
            } else if (delta > 0) {
                indent = indent + INDENT;
            }
            String insertedWhitespace = SEPARATOR + indent;
            xmlText = xmlText.substring(0, i + 1) + insertedWhitespace + xmlText.substring(i + 1);
            startLookingAtIndex = i + insertedWhitespace.length() + 1;
        }
        return xmlText;
    }

    private int changeIndent(String xmlText, int startingIndex, char peekAhead) {
        int index = startingIndex;
        while (--index > 0) {
            char c = xmlText.charAt(index);
            switch (c) {
                case '<': {
                    return 1;
                }
                case '?': {
                    return 0;
                }
                case '/': {
                    if (index + 1 == startingIndex) {
                        return -1;
                    }
                    return peekAhead == '/' ? -1 : 0;
                }
            }
        }
        return 0;
    }

    private char priorNonWhitespace(String xmlText, int index) {
        char c;
        do {
            if (--index > 0) continue;
            return xmlText.charAt(0);
        } while (Character.isWhitespace(c = xmlText.charAt(index)));
        return c;
    }

    private boolean isClosing(String xmlText, int index) {
        while (--index > 0) {
            char c = xmlText.charAt(index);
            switch (c) {
                case '<': {
                    return false;
                }
                case '/': 
                case '?': {
                    return true;
                }
            }
        }
        return false;
    }
}

